/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import org.opentripplanner.framework.io.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDataListDownloader<T> {
    private static final Logger log = LoggerFactory.getLogger(JsonDataListDownloader.class);
    private final String jsonParsePath;
    private final Map<String, String> headers;
    private final Function<JsonNode, T> elementParser;
    private final String url;

    public JsonDataListDownloader(String url, String jsonParsePath, Function<JsonNode, T> elementParser, Map<String, String> headers) {
        this.url = url;
        this.jsonParsePath = jsonParsePath;
        this.headers = headers;
        this.elementParser = elementParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> download() {
        if (this.url == null) {
            log.warn("Cannot download updates, because url is null!");
            return null;
        }
        try (InputStream data = HttpUtils.openInputStream(this.url, this.headers);){
            if (data == null) {
                log.warn("Failed to get data from url {}", (Object)this.url);
                List<T> list2 = null;
                return list2;
            }
            List<T> list = this.parseJSON(data);
            return list;
        }
        catch (IllegalArgumentException e) {
            log.warn("Error parsing bike rental feed from {}", (Object)this.url, (Object)e);
            return null;
        }
        catch (JsonProcessingException e) {
            log.warn("Error parsing bike rental feed from {} (bad JSON of some sort)", (Object)this.url, (Object)e);
            return null;
        }
        catch (IOException e) {
            log.warn("Error reading bike rental feed from {}", (Object)this.url, (Object)e);
        }
        return null;
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner scanner = new Scanner(is).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }

    private List<T> parseJSON(InputStream dataStream) throws IllegalArgumentException, IOException {
        ArrayList<T> out = new ArrayList<T>();
        String rentalString = JsonDataListDownloader.convertStreamToString(dataStream);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(rentalString);
        if (!this.jsonParsePath.equals("")) {
            String[] parseElement;
            String delimiter = "/";
            for (String s : parseElement = this.jsonParsePath.split(delimiter)) {
                rootNode = rootNode.path(s);
            }
            if (rootNode.isMissingNode()) {
                throw new IllegalArgumentException("Could not find jSON elements " + this.jsonParsePath);
            }
        }
        for (JsonNode node : rootNode) {
            if (node == null) continue;
            try {
                T parsedElement = this.elementParser.apply(node);
                if (parsedElement == null) continue;
                out.add(parsedElement);
            }
            catch (Exception e) {
                log.error("Could not process element in JSON list downloaded from {}", (Object)this.url, (Object)e);
            }
        }
        return out;
    }
}

