/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.i18n;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.resources.ResourceBundleSingleton;

public class LocalizedString
implements I18NString,
Serializable {
    private static final Pattern patternMatcher = Pattern.compile("\\{(.*?)}");
    private final String key;
    private final I18NString[] params;

    public LocalizedString(String key) {
        this.key = key;
        this.params = null;
    }

    public LocalizedString(String key, I18NString ... params) {
        this.key = key;
        this.params = params;
    }

    public int hashCode() {
        int result = Objects.hash(this.key);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof LocalizedString && this.key.equals(((LocalizedString)other).key) && Arrays.equals(this.params, ((LocalizedString)other).params);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Locale locale) {
        if (this.key == null) {
            return null;
        }
        String translation = ResourceBundleSingleton.INSTANCE.localize(this.key, locale);
        if (this.params != null) {
            translation = patternMatcher.matcher(translation).replaceAll("%s");
            return String.format(translation, Arrays.stream(this.params).map(i -> i.toString(locale)).toArray(Object[]::new));
        }
        return translation;
    }
}

