/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.geometry;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;

public abstract class SphericalDistanceLibrary {
    public static final double RADIUS_OF_EARTH_IN_KM = 6371.01;
    public static final double RADIUS_OF_EARTH_IN_M = 6371010.0;
    public static final double MAX_LAT_DELTA_DEG = 4.0;
    public static final double MAX_LON_DELTA_DEG = 4.0;
    public static final double MAX_ERR_INV = 0.999462;

    public static double distance(Coordinate from, Coordinate to) {
        return SphericalDistanceLibrary.distance(from.y, from.x, to.y, to.x);
    }

    public static double fastDistance(Coordinate from, Coordinate to) {
        return SphericalDistanceLibrary.fastDistance(from.y, from.x, to.y, to.x);
    }

    public static double fastDistance(Coordinate from, Coordinate to, double cosLat) {
        double dLat = Math.toRadians(from.y - to.y);
        double dLon = Math.toRadians(from.x - to.x) * cosLat;
        return 6371010.0 * Math.sqrt(dLat * dLat + dLon * dLon);
    }

    public static double fastDistance(Coordinate point, LineString lineString) {
        double lat = Math.toRadians(point.y);
        double cosLat = Math.cos(lat);
        double lon = Math.toRadians(point.x) * cosLat;
        Point point2 = GeometryUtils.getGeometryFactory().createPoint(new Coordinate(lon, lat));
        LineString lineString2 = SphericalDistanceLibrary.equirectangularProject(lineString, cosLat);
        return lineString2.distance((Geometry)point2) * 6371010.0;
    }

    public static double length(LineString lineString) {
        double accumulatedMeters = 0.0;
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            accumulatedMeters += SphericalDistanceLibrary.distance(lineString.getCoordinateN(i - 1), lineString.getCoordinateN(i));
        }
        return accumulatedMeters;
    }

    public static double fastLength(LineString lineString) {
        Coordinate[] coordinates = lineString.getCoordinates();
        double middleY = (coordinates[0].y + coordinates[coordinates.length - 1].y) / 2.0;
        double cosLat = Math.cos(Math.toRadians(middleY));
        return SphericalDistanceLibrary.equirectangularProject(lineString, cosLat).getLength() * 6371010.0;
    }

    public static double fastLength(LineString lineString, double cosLat) {
        return SphericalDistanceLibrary.equirectangularProject(lineString, cosLat).getLength() * 6371010.0;
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2) {
        return SphericalDistanceLibrary.distance(lat1, lon1, lat2, lon2, 6371010.0);
    }

    public static double fastDistance(double lat1, double lon1, double lat2, double lon2) {
        return SphericalDistanceLibrary.fastDistance(lat1, lon1, lat2, lon2, 6371010.0);
    }

    public static double distance(double lat1, double lon1, double lat2, double lon2, double radius) {
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        double deltaLon = lon2 - lon1;
        double y = Math.sqrt(SphericalDistanceLibrary.p2(Math.cos(lat2) * Math.sin(deltaLon)) + SphericalDistanceLibrary.p2(Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(deltaLon)));
        double x = Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(deltaLon);
        return radius * Math.atan2(y, x);
    }

    public static double fastDistance(double lat1, double lon1, double lat2, double lon2, double radius) {
        if (Math.abs(lat1 - lat2) > 4.0 || Math.abs(lon1 - lon2) > 4.0) {
            return SphericalDistanceLibrary.distance(lat1, lon1, lat2, lon2, radius);
        }
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1) * Math.cos(Math.toRadians((lat1 + lat2) / 2.0));
        return radius * Math.sqrt(dLat * dLat + dLon * dLon) * 0.999462;
    }

    public static double metersToDegrees(double distanceMeters) {
        return 360.0 * distanceMeters / 4.003023642389422E7;
    }

    public static double degreesLatitudeToMeters(double degreesLatitude) {
        return 4.003023642389422E7 * degreesLatitude / 360.0;
    }

    public static double metersToLonDegrees(double distanceMeters, double latDeg) {
        double dLatDeg = 360.0 * distanceMeters / 4.003023642389422E7;
        double minCosLat = latDeg > 0.0 ? Math.cos(Math.toRadians(latDeg + dLatDeg)) : Math.cos(Math.toRadians(latDeg - dLatDeg));
        return dLatDeg / minCosLat;
    }

    public static Envelope bounds(double lat, double lon, double latDistance, double lonDistance) {
        double radiusOfEarth = 6371010.0;
        double latRadians = Math.toRadians(lat);
        double lonRadians = Math.toRadians(lon);
        double lonRadius = Math.cos(latRadians) * radiusOfEarth;
        double latOffset = latDistance / radiusOfEarth;
        double lonOffset = lonDistance / lonRadius;
        double latFrom = Math.toDegrees(latRadians - latOffset);
        double latTo = Math.toDegrees(latRadians + latOffset);
        double lonFrom = Math.toDegrees(lonRadians - lonOffset);
        double lonTo = Math.toDegrees(lonRadians + lonOffset);
        return new Envelope(new Coordinate(lonFrom, latFrom), new Coordinate(lonTo, latTo));
    }

    private static LineString equirectangularProject(LineString lineString, double cosLat) {
        Coordinate[] coords = lineString.getCoordinates();
        Coordinate[] coords2 = new Coordinate[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            coords2[i] = new Coordinate(Math.toRadians(coords[i].x) * cosLat, Math.toRadians(coords[i].y));
        }
        return GeometryUtils.getGeometryFactory().createLineString(coords2);
    }

    private static double p2(double a) {
        return a * a;
    }
}

