/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicletostopheuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.filter.TransitFilter;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;

public class VehicleToStopSkipEdgeStrategy
implements SkipEdgeStrategy<State, Edge> {
    public static final Set<StreetMode> applicableModes = Set.of(StreetMode.BIKE_TO_PARK, StreetMode.BIKE_RENTAL, StreetMode.CAR_TO_PARK, StreetMode.CAR_PICKUP, StreetMode.CAR_HAILING, StreetMode.CAR_RENTAL, StreetMode.SCOOTER_RENTAL);
    private final Function<RegularStop, Collection<TripPattern>> getPatternsForStop;
    private final int maxScore;
    private final List<TransitFilter> filters;
    private double sumOfScores;
    private final Set<FeedScopedId> stopsCounted = new HashSet<FeedScopedId>();

    public VehicleToStopSkipEdgeStrategy(Function<RegularStop, Collection<TripPattern>> getPatternsForStop, Collection<TransitFilter> filters) {
        this.filters = new ArrayList<TransitFilter>(filters);
        this.maxScore = 300;
        this.getPatternsForStop = getPatternsForStop;
    }

    @Override
    public boolean shouldSkipEdge(State current, Edge edge) {
        if (current.getNonTransitMode().isWalking()) {
            TransitStopVertex stopVertex;
            Vertex vertex = current.getVertex();
            if (vertex instanceof TransitStopVertex && !this.stopsCounted.contains((stopVertex = (TransitStopVertex)vertex).getStop().getId())) {
                RegularStop stop = stopVertex.getStop();
                Collection<TripPattern> patterns = this.getPatternsForStop.apply(stop);
                int score = 0;
                block0: for (TripPattern pattern : patterns) {
                    for (TransitFilter filter : this.filters) {
                        if (!filter.matchTripPattern(pattern)) continue;
                        score += VehicleToStopSkipEdgeStrategy.score(pattern.getMode());
                        continue block0;
                    }
                }
                this.stopsCounted.add(stop.getId());
                this.sumOfScores += (double)score;
            }
            return false;
        }
        return this.sumOfScores >= (double)this.maxScore;
    }

    private static int score(TransitMode mode) {
        return switch (mode) {
            case TransitMode.RAIL, TransitMode.FERRY, TransitMode.SUBWAY -> 20;
            case TransitMode.BUS -> 1;
            default -> 2;
        };
    }
}

