/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vehicleparking.bikely;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Currency;
import org.opentripplanner.ext.vehicleparking.bikely.BikelyUpdaterParameters;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingState;
import org.opentripplanner.transit.model.basic.LocalizedMoney;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.spi.GenericJsonDataSource;

public class BikelyUpdater
extends GenericJsonDataSource<VehicleParking> {
    private static final String JSON_PARSE_PATH = "result";
    private static final Currency NOK = Currency.getInstance("NOK");
    private final String feedId;

    public BikelyUpdater(BikelyUpdaterParameters parameters) {
        super(parameters.url(), JSON_PARSE_PATH, parameters.httpHeaders());
        this.feedId = parameters.feedId();
    }

    @Override
    protected VehicleParking parseElement(JsonNode jsonNode) {
        FeedScopedId vehicleParkId = new FeedScopedId(this.feedId, jsonNode.get("id").asText());
        JsonNode address = jsonNode.get("address");
        JsonNode workingHours = jsonNode.get("workingHours");
        double lat = address.get("latitude").asDouble();
        double lng = address.get("longitude").asDouble();
        WgsCoordinate coord = new WgsCoordinate(lat, lng);
        NonLocalizedString name = new NonLocalizedString(jsonNode.path("name").asText());
        int totalSpots = jsonNode.get("totalParkingSpots").asInt();
        int freeSpots = jsonNode.get("availableParkingSpots").asInt();
        boolean isUnderMaintenance = workingHours.get("isUnderMaintenance").asBoolean();
        LocalizedString note = BikelyUpdater.toNote(jsonNode.get("price"));
        VehicleParking.VehicleParkingEntranceCreator entrance = builder -> builder.entranceId(new FeedScopedId(this.feedId, vehicleParkId.getId() + "/entrance")).name(name).coordinate(coord).walkAccessible(true).carAccessible(false);
        return VehicleParking.builder().id(vehicleParkId).name(name).bicyclePlaces(true).capacity(VehicleParkingSpaces.builder().bicycleSpaces(totalSpots).build()).availability(VehicleParkingSpaces.builder().bicycleSpaces(freeSpots).build()).state(BikelyUpdater.toState(isUnderMaintenance)).coordinate(coord).entrance(entrance).note(note).build();
    }

    private static LocalizedString toNote(JsonNode price) {
        double startPriceAmount = price.get("startPriceAmount").asDouble();
        double mainPriceAmount = price.get("mainPriceAmount").asDouble();
        int startPriceDurationHours = price.get("startPriceDurationHours").asInt();
        int mainPriceDurationHours = price.get("mainPriceDurationHours").asInt();
        if (startPriceAmount == 0.0 && mainPriceAmount == 0.0) {
            return new LocalizedString("price.free");
        }
        return new LocalizedString("price.startMain", NonLocalizedString.ofNumber(startPriceDurationHours), new LocalizedMoney(new Money(NOK, (int)(startPriceAmount * 100.0))), new LocalizedMoney(new Money(NOK, (int)(mainPriceAmount * 100.0))), NonLocalizedString.ofNumber(mainPriceDurationHours));
    }

    private static VehicleParkingState toState(boolean isUnderMaintenance) {
        if (isUnderMaintenance) {
            return VehicleParkingState.TEMPORARILY_CLOSED;
        }
        return VehicleParkingState.OPERATIONAL;
    }
}

