/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.vehiclerental.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.opentripplanner.api.mapping.I18NStringMapper;
import org.opentripplanner.api.mapping.PropertyMapper;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;

public class DigitransitVehicleRentalStationPropertyMapper
extends PropertyMapper<VehicleRentalStation> {
    private final I18NStringMapper i18NStringMapper;

    public DigitransitVehicleRentalStationPropertyMapper(Locale locale) {
        this.i18NStringMapper = new I18NStringMapper(locale);
    }

    @Override
    protected Collection<KeyValue> map(VehicleRentalStation station) {
        ArrayList<KeyValue> items = new ArrayList<KeyValue>();
        items.addAll(DigitransitVehicleRentalStationPropertyMapper.getFeedScopedIdAndNetwork(station));
        items.addAll(DigitransitVehicleRentalStationPropertyMapper.getNameAndFormFactors(station, this.i18NStringMapper));
        return items;
    }

    protected static List<KeyValue> getFeedScopedIdAndNetwork(VehicleRentalPlace vehicleRentalPlace) {
        return List.of(new KeyValue("id", vehicleRentalPlace.getId().toString()), new KeyValue("network", vehicleRentalPlace.getNetwork()));
    }

    protected static List<KeyValue> getNameAndFormFactors(VehicleRentalStation vehicleRentalStation, I18NStringMapper i18NStringMapper) {
        return List.of(new KeyValue("name", i18NStringMapper.mapToApi(vehicleRentalStation.getName())), new KeyValue("formFactors", vehicleRentalStation.formFactors().stream().map(Enum::name).sorted().collect(Collectors.joining(","))));
    }
}

