/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles.layers.vehicleparkings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.simple.JSONObject;
import org.opentripplanner.api.mapping.I18NStringMapper;
import org.opentripplanner.api.mapping.PropertyMapper;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.DigitransitVehicleParkingPropertyMapper;
import org.opentripplanner.inspector.vector.KeyValue;
import org.opentripplanner.model.calendar.openinghours.OsmOpeningHoursSupport;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;

public class StadtnaviVehicleParkingPropertyMapper
extends PropertyMapper<VehicleParking> {
    private final DigitransitVehicleParkingPropertyMapper digitransitMapper;
    private final I18NStringMapper i18NStringMapper;

    public StadtnaviVehicleParkingPropertyMapper(Locale locale) {
        this.i18NStringMapper = new I18NStringMapper(locale);
        this.digitransitMapper = DigitransitVehicleParkingPropertyMapper.create(locale);
    }

    protected static StadtnaviVehicleParkingPropertyMapper create(Locale locale) {
        return new StadtnaviVehicleParkingPropertyMapper(locale);
    }

    @Override
    protected Collection<KeyValue> map(VehicleParking vehicleParking) {
        ArrayList<KeyValue> items = this.digitransitMapper.basicMapping(vehicleParking);
        items.addAll(List.of(new KeyValue("realTimeData", vehicleParking.getAvailability() != null), new KeyValue("detailsUrl", vehicleParking.getDetailsUrl()), new KeyValue("imageUrl", vehicleParking.getImageUrl()), new KeyValue("tags", String.join((CharSequence)",", vehicleParking.getTags())), new KeyValue("state", vehicleParking.getState().name()), new KeyValue("realTimeData", vehicleParking.hasRealTimeData()), new KeyValue("note", this.i18NStringMapper.mapToApi(vehicleParking.getNote()))));
        if (vehicleParking.getOpeningHours() != null) {
            items.add(new KeyValue("openingHours", OsmOpeningHoursSupport.osmFormat(vehicleParking.getOpeningHours())));
        }
        items.addAll(StadtnaviVehicleParkingPropertyMapper.mapPlaces("capacity", vehicleParking.getCapacity()));
        items.addAll(StadtnaviVehicleParkingPropertyMapper.mapPlaces("availability", vehicleParking.getAvailability()));
        return items;
    }

    private static List<KeyValue> mapPlaces(String key, VehicleParkingSpaces places) {
        if (places == null) {
            return List.of();
        }
        JSONObject json = new JSONObject();
        json.put((Object)"bicyclePlaces", (Object)places.getBicycleSpaces());
        json.put((Object)"carPlaces", (Object)places.getCarSpaces());
        json.put((Object)"wheelchairAccessibleCarPlaces", (Object)places.getWheelchairAccessibleCarSpaces());
        return List.of(new KeyValue(key, JSONObject.toJSONString((Map)json)), new KeyValue(StadtnaviVehicleParkingPropertyMapper.subKey(key, "bicyclePlaces"), places.getBicycleSpaces()), new KeyValue(StadtnaviVehicleParkingPropertyMapper.subKey(key, "carPlaces"), places.getCarSpaces()), new KeyValue(StadtnaviVehicleParkingPropertyMapper.subKey(key, "wheelchairAccessibleCarPlaces"), places.getWheelchairAccessibleCarSpaces()));
    }

    private static String subKey(String key, String subkey) {
        return String.format("%s.%s", key, subkey);
    }
}

