/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.vectortiles;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.glassfish.grizzly.http.server.Request;
import org.opentripplanner.api.model.TileJson;
import org.opentripplanner.ext.vectortiles.layers.stations.StationsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.stops.StopsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingGroupsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehicleparkings.VehicleParkingsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehiclerental.VehicleRentalPlacesLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehiclerental.VehicleRentalStationsLayerBuilder;
import org.opentripplanner.ext.vectortiles.layers.vehiclerental.VehicleRentalVehiclesLayerBuilder;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.inspector.vector.VectorTileResponseFactory;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/routers/{ignoreRouterId}/vectorTiles")
public class VectorTilesResource {
    private final OtpServerRequestContext serverContext;
    private final String ignoreRouterId;
    private final Locale locale;

    public VectorTilesResource(@Context OtpServerRequestContext serverContext, @Context Request grizzlyRequest, @Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.locale = grizzlyRequest.getLocale();
        this.serverContext = serverContext;
        this.ignoreRouterId = ignoreRouterId;
    }

    @GET
    @Path(value="/{layers}/{z}/{x}/{y}.pbf")
    @Produces(value={"application/x-protobuf"})
    public Response tileGet(@PathParam(value="x") int x, @PathParam(value="y") int y, @PathParam(value="z") int z, @PathParam(value="layers") String requestedLayers) {
        return VectorTileResponseFactory.create(x, y, z, this.locale, Arrays.asList(requestedLayers.split(",")), this.serverContext.vectorTileLayers().layers(), VectorTilesResource::crateLayerBuilder, this.serverContext);
    }

    @GET
    @Path(value="/{layers}/tilejson.json")
    @Produces(value={"application/json"})
    public TileJson getTileJson(@Context UriInfo uri, @Context HttpHeaders headers, @PathParam(value="layers") String requestedLayers) {
        WorldEnvelope envelope = this.serverContext.worldEnvelopeService().envelope().orElseThrow();
        List<FeedInfo> feedInfos = this.serverContext.transitService().getFeedIds().stream().map(this.serverContext.transitService()::getFeedInfo).filter(Predicate.not(Objects::isNull)).toList();
        return new TileJson(uri, headers, requestedLayers, this.ignoreRouterId, "vectorTiles", envelope, feedInfos);
    }

    private static LayerBuilder<?> crateLayerBuilder(LayerParameters<LayerType> layerParameters, Locale locale, OtpServerRequestContext context) {
        return switch (layerParameters.type()) {
            default -> throw new IncompatibleClassChangeError();
            case LayerType.Stop -> new StopsLayerBuilder(context.transitService(), layerParameters, locale);
            case LayerType.Station -> new StationsLayerBuilder(context.transitService(), layerParameters, locale);
            case LayerType.VehicleRental -> new VehicleRentalPlacesLayerBuilder(context.vehicleRentalService(), layerParameters, locale);
            case LayerType.VehicleRentalStation -> new VehicleRentalStationsLayerBuilder(context.vehicleRentalService(), layerParameters, locale);
            case LayerType.VehicleRentalVehicle -> new VehicleRentalVehiclesLayerBuilder(context.vehicleRentalService(), layerParameters);
            case LayerType.VehicleParking -> new VehicleParkingsLayerBuilder(context.graph(), layerParameters, locale);
            case LayerType.VehicleParkingGroup -> new VehicleParkingGroupsLayerBuilder(context.graph(), layerParameters, locale);
        };
    }

    public static interface LayersParameters<T extends Enum<T>> {
        public List<LayerParameters<T>> layers();
    }

    public static enum LayerType {
        Stop,
        Station,
        VehicleRental,
        VehicleRentalVehicle,
        VehicleRentalStation,
        VehicleParking,
        VehicleParkingGroup;

    }
}

