/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import java.util.ArrayList;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.traveltime.WTWD;
import org.opentripplanner.ext.traveltime.geometry.AccumulativeMetric;
import org.opentripplanner.ext.traveltime.geometry.ZSamplePoint;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;

public class WTWDAccumulativeMetric
implements AccumulativeMetric<WTWD> {
    private final double cosLat;
    private final double offRoadDistanceMeters;
    private final double offRoadSpeed;
    private final double gridSizeMeters;

    public WTWDAccumulativeMetric(double cosLat, double offRoadDistanceMeters, double offRoadSpeed, double gridSizeMeters) {
        this.cosLat = cosLat;
        this.offRoadDistanceMeters = offRoadDistanceMeters;
        this.offRoadSpeed = offRoadSpeed;
        this.gridSizeMeters = gridSizeMeters;
    }

    @Override
    public WTWD cumulateSample(Coordinate C0, Coordinate Cs, WTWD z, WTWD zS, double offRoadSpeed) {
        double t = z.wTime / z.w;
        double wd = z.wWalkDist / z.w;
        double d = SphericalDistanceLibrary.fastDistance(C0, Cs, this.cosLat);
        double dt = d / offRoadSpeed;
        double w = 1.0 / ((d + this.gridSizeMeters) * (d + this.gridSizeMeters));
        if (zS == null) {
            zS = new WTWD();
            zS.d = Double.MAX_VALUE;
        }
        zS.w += w;
        zS.wTime += w * (t + dt);
        zS.wWalkDist += w * (wd + d);
        if (d < zS.d) {
            zS.d = d;
        }
        return zS;
    }

    @Override
    public boolean closeSample(ZSamplePoint<WTWD> point) {
        double dMin = Double.MAX_VALUE;
        double tMin = Double.MAX_VALUE;
        double wdMin = Double.MAX_VALUE;
        ArrayList<WTWD> zz = new ArrayList<WTWD>(4);
        if (point.up() != null) {
            zz.add(point.up().getZ());
        }
        if (point.down() != null) {
            zz.add(point.down().getZ());
        }
        if (point.right() != null) {
            zz.add(point.right().getZ());
        }
        if (point.left() != null) {
            zz.add(point.left().getZ());
        }
        for (WTWD z : zz) {
            double wd;
            double t;
            if (z.d < dMin) {
                dMin = z.d;
            }
            if ((t = z.wTime / z.w) < tMin) {
                tMin = t;
            }
            if (!((wd = z.wWalkDist / z.w) < wdMin)) continue;
            wdMin = wd;
        }
        WTWD z = new WTWD();
        z.w = 1.0;
        z.wTime = tMin + this.gridSizeMeters / this.offRoadSpeed;
        z.wWalkDist = wdMin + this.gridSizeMeters;
        z.d = dMin + this.gridSizeMeters;
        point.setZ(z);
        return dMin > this.offRoadDistanceMeters;
    }
}

