/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.traveltime;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geojson.MultiPolygon;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opentripplanner.ext.traveltime.IsochroneData;
import org.opentripplanner.ext.traveltime.IsolineMetric;
import org.opentripplanner.ext.traveltime.TravelTimeRequest;
import org.opentripplanner.ext.traveltime.WTWD;
import org.opentripplanner.ext.traveltime.geometry.DelaunayIsolineBuilder;
import org.opentripplanner.ext.traveltime.geometry.ZSampleGrid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsochroneRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(IsochroneRenderer.class);
    private static final SimpleFeatureType contourSchema = IsochroneRenderer.makeContourSchema();

    static List<IsochroneData> renderIsochrones(ZSampleGrid<WTWD> sampleGrid, TravelTimeRequest traveltimeRequest) {
        long t0 = System.currentTimeMillis();
        IsolineMetric zMetric = new IsolineMetric();
        DelaunayIsolineBuilder<WTWD> isolineBuilder = new DelaunayIsolineBuilder<WTWD>(sampleGrid.delaunayTriangulate(), zMetric);
        isolineBuilder.setDebug(traveltimeRequest.includeDebugGeometry);
        ArrayList<IsochroneData> isochrones = new ArrayList<IsochroneData>();
        for (Duration cutoff : traveltimeRequest.cutoffs) {
            long cutoffSec = cutoff.toSeconds();
            WTWD z0 = new WTWD();
            z0.w = 1.0;
            z0.wTime = cutoffSec;
            z0.d = traveltimeRequest.offRoadDistanceMeters;
            Geometry geometry = isolineBuilder.computeIsoline(z0);
            Geometry debugGeometry = null;
            Objects.requireNonNull(traveltimeRequest);
            isochrones.add(new IsochroneData(cutoffSec, geometry, debugGeometry));
        }
        long t1 = System.currentTimeMillis();
        LOG.info("Computed {} isochrones in {}msec", (Object)isochrones.size(), (Object)((int)(t1 - t0)));
        return isochrones;
    }

    static SimpleFeatureCollection makeContourFeatures(List<IsochroneData> isochrones) {
        DefaultFeatureCollection featureCollection = new DefaultFeatureCollection(null, contourSchema);
        SimpleFeatureBuilder fbuilder = new SimpleFeatureBuilder(contourSchema);
        for (IsochroneData isochrone : isochrones) {
            fbuilder.add((Object)isochrone.geometry());
            fbuilder.add((Object)isochrone.cutoffSec());
            featureCollection.add(fbuilder.buildFeature(null));
        }
        return featureCollection;
    }

    private static SimpleFeatureType makeContourSchema() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("contours");
        typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        typeBuilder.setDefaultGeometry("the_geom");
        typeBuilder.add("the_geom", MultiPolygon.class);
        typeBuilder.add("time", Long.class);
        return typeBuilder.buildFeatureType();
    }
}

