/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.timetable;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.TripTimeOnDate;

public class TimetabledPassingTimeType {
    private static final String NAME = "TimetabledPassingTime";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("TimetabledPassingTime");

    public static GraphQLObjectType create(GraphQLOutputType bookingArrangementType, GraphQLOutputType noticeType, GraphQLOutputType quayType, GraphQLOutputType destinationDisplayType, GraphQLOutputType serviceJourneyType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).description("Scheduled passing times. These are not affected by real time updates.").field(GraphQLFieldDefinition.newFieldDefinition().name("quay").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)quayType)).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getStop()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("arrival").type((GraphQLOutputType)gqlUtil.timeScalar).description("Scheduled time of arrival at quay").dataFetcher(environment -> TimetabledPassingTimeType.missingValueToNull(((TripTimeOnDate)environment.getSource()).getScheduledArrival())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("departure").type((GraphQLOutputType)gqlUtil.timeScalar).description("Scheduled time of departure from quay").dataFetcher(environment -> TimetabledPassingTimeType.missingValueToNull(((TripTimeOnDate)environment.getSource()).getScheduledDeparture())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("timingPoint").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether this is a timing point or not. Boarding and alighting is not allowed at timing points.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).isTimepoint()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("forBoarding").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether vehicle may be boarded at quay.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getPickupType() != PickDrop.NONE).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("forAlighting").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether vehicle may be alighted at quay.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getDropoffType() != PickDrop.NONE).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("requestStop").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether vehicle will only stop on request.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getDropoffType() == PickDrop.COORDINATE_WITH_DRIVER).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("earliestDepartureTime").type((GraphQLOutputType)gqlUtil.timeScalar).description("Earliest possible departure time for a service journey with a service window.").dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            FlexTrip<?, ?> flexTrip = TimetabledPassingTimeType.getFlexTrip(environment, tripTimeOnDate);
            if (flexTrip == null) {
                return null;
            }
            return TimetabledPassingTimeType.missingValueToNull(flexTrip.earliestDepartureTime(tripTimeOnDate.getStopIndex()));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("latestArrivalTime").type((GraphQLOutputType)gqlUtil.timeScalar).description("Latest possible (planned) arrival time for a service journey with a service window.").dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            FlexTrip<?, ?> flexTrip = TimetabledPassingTimeType.getFlexTrip(environment, tripTimeOnDate);
            if (flexTrip == null) {
                return null;
            }
            return TimetabledPassingTimeType.missingValueToNull(flexTrip.latestArrivalTime(tripTimeOnDate.getStopIndex()));
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)serviceJourneyType)).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getTrip()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("destinationDisplay").type(destinationDisplayType).dataFetcher(DataFetchingEnvironment::getSource).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("notices").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)noticeType)))).dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            return GqlUtil.getTransitService(environment).getNoticesByEntity(tripTimeOnDate.getStopTimeKey());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingArrangements").description("Booking arrangements for this passing time.").type(bookingArrangementType).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getPickupBookingInfo()).build()).build();
    }

    private static FlexTrip<?, ?> getFlexTrip(DataFetchingEnvironment environment, TripTimeOnDate tripTimeOnDate) {
        if (OTPFeature.FlexRouting.isOff()) {
            return null;
        }
        return GqlUtil.getTransitService(environment).getFlexIndex().getTripById(tripTimeOnDate.getTrip().getId());
    }

    private static Integer missingValueToNull(int value) {
        if (value == -999) {
            return null;
        }
        return value;
    }
}

