/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.stop;

import graphql.Scalars;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.model.plan.JourneyWhiteListed;
import org.opentripplanner.ext.transmodelapi.model.scalars.GeoJSONCoordinatesScalar;
import org.opentripplanner.ext.transmodelapi.model.stop.MonoOrMultiModalStation;
import org.opentripplanner.ext.transmodelapi.model.stop.StopPlaceType;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;

public class QuayType {
    private static final String NAME = "Quay";
    public static final GraphQLOutputType REF = new GraphQLTypeReference("Quay");

    public static GraphQLObjectType create(GraphQLInterfaceType placeInterface, GraphQLOutputType stopPlaceType, GraphQLOutputType lineType, GraphQLOutputType journeyPatternType, GraphQLOutputType estimatedCallType, GraphQLOutputType ptSituationElementType, GraphQLOutputType tariffZoneType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).description("A place such as platform, stance, or quayside where passengers have access to PT vehicles.").withInterface(placeInterface).field(GqlUtil.newTransitIdField()).field(GraphQLFieldDefinition.newFieldDefinition().name("name").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLString)).argument(GraphQLArgument.newArgument().name("lang").description("Fetch the name in the language given. The language should be represented as a ISO-639 language code. If the translation does not exits, the default name is returned.").type((GraphQLInputType)Scalars.GraphQLString).build()).dataFetcher(environment -> {
            String lang = (String)environment.getArgument("lang");
            Locale locale = lang != null ? new Locale(lang) : null;
            return ((StopLocation)environment.getSource()).getName().toString(locale);
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("latitude").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((StopLocation)environment.getSource()).getLat()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("longitude").type((GraphQLOutputType)Scalars.GraphQLFloat).dataFetcher(environment -> ((StopLocation)environment.getSource()).getLon()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("description").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> GraphQLUtils.getTranslation(((StopLocation)environment.getSource()).getDescription(), environment)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPlace").description("The stop place to which this quay belongs to.").type(stopPlaceType).dataFetcher(environment -> {
            Station station = ((StopLocation)environment.getSource()).getParentStation();
            if (station != null) {
                return new MonoOrMultiModalStation(station, GqlUtil.getTransitService(environment).getMultiModalStationForStation(station));
            }
            return null;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("wheelchairAccessible").type((GraphQLOutputType)EnumTypes.WHEELCHAIR_BOARDING).description("Whether this quay is suitable for wheelchair boarding.").dataFetcher(environment -> Objects.requireNonNullElse(((StopLocation)environment.getSource()).getWheelchairAccessibility(), Accessibility.NO_INFORMATION)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("timeZone").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> Optional.ofNullable(((StopLocation)environment.getSource()).getTimeZone()).map(ZoneId::getId)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("publicCode").type((GraphQLOutputType)Scalars.GraphQLString).description("Public code used to identify this quay within the stop place. For instance a platform code.").dataFetcher(environment -> ((StopLocation)environment.getSource()).getPlatformCode()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("lines").withDirective(gqlUtil.timingData).description("List of lines servicing this quay").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)lineType)))).dataFetcher(environment -> GqlUtil.getTransitService(environment).getPatternsForStop((StopLocation)environment.getSource(), true).stream().map(pattern -> pattern.getRoute()).distinct().collect(Collectors.toList())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("journeyPatterns").withDirective(gqlUtil.timingData).description("List of journey patterns servicing this quay").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)journeyPatternType))).dataFetcher(environment -> GqlUtil.getTransitService(environment).getPatternsForStop((StopLocation)environment.getSource(), true)).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("estimatedCalls").withDirective(gqlUtil.timingData).description("List of visits to this quay as part of vehicle journeys.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)estimatedCallType)))).argument(GraphQLArgument.newArgument().name("startTime").type((GraphQLInputType)gqlUtil.dateTimeScalar).description("DateTime for when to fetch estimated calls from. Default value is current time").build()).argument(GraphQLArgument.newArgument().name("timeRange").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)86400).build()).argument(GraphQLArgument.newArgument().name("numberOfDepartures").description("Limit the total number of departures returned.").type((GraphQLInputType)Scalars.GraphQLInt).defaultValue((Object)5).build()).argument(GraphQLArgument.newArgument().name("numberOfDeparturesPerLineAndDestinationDisplay").description("Limit the number of departures per line and destination display returned. The parameter is only applied when the value is between 1 and 'numberOfDepartures'.").type((GraphQLInputType)Scalars.GraphQLInt).build()).argument(GraphQLArgument.newArgument().name("omitNonBoarding").type((GraphQLInputType)Scalars.GraphQLBoolean).deprecate("Non-functional. Use arrivalDeparture instead.").defaultValue((Object)false).build()).argument(GraphQLArgument.newArgument().name("arrivalDeparture").type((GraphQLInputType)EnumTypes.ARRIVAL_DEPARTURE).description("Filters results by either departures, arrivals or both. For departures forBoarding has to be true and the departure time has to be within the specified time range. For arrivals, forAlight has to be true and the arrival time has to be within the specified time range. If both are asked for, either the conditions for arrivals or the conditions for departures will have to be true for an EstimatedCall to show.").defaultValue((Object)ArrivalDeparture.DEPARTURES).build()).argument(GraphQLArgument.newArgument().name("whiteListed").description("Whitelisted").description("Parameters for indicating the only authorities and/or lines or quays to list estimatedCalls for").type((GraphQLInputType)JourneyWhiteListed.INPUT_TYPE).build()).argument(GraphQLArgument.newArgument().name("whiteListedModes").description("Only show estimated calls for selected modes.").type((GraphQLInputType)GraphQLList.list((GraphQLType)EnumTypes.TRANSPORT_MODE)).build()).argument(GraphQLArgument.newArgument().name("includeCancelledTrips").description("Indicates that realtime-cancelled trips should also be included.").type((GraphQLInputType)Scalars.GraphQLBoolean).defaultValue((Object)false).build()).dataFetcher(environment -> {
            ArrivalDeparture arrivalDeparture = (ArrivalDeparture)((Object)((Object)environment.getArgument("arrivalDeparture")));
            boolean includeCancelledTrips = (Boolean)environment.getArgument("includeCancelledTrips");
            int numberOfDepartures = (Integer)environment.getArgument("numberOfDepartures");
            Integer departuresPerLineAndDestinationDisplay = (Integer)environment.getArgument("numberOfDeparturesPerLineAndDestinationDisplay");
            Integer timeRangeInput = (Integer)environment.getArgument("timeRange");
            Duration timeRange = Duration.ofSeconds(timeRangeInput.longValue());
            RegularStop stop = (RegularStop)environment.getSource();
            JourneyWhiteListed whiteListed = new JourneyWhiteListed(environment);
            Collection transitModes = (Collection)environment.getArgument("whiteListedModes");
            Instant startTime = environment.containsArgument("startTime") ? Instant.ofEpochMilli((Long)environment.getArgument("startTime")) : Instant.now();
            return StopPlaceType.getTripTimesForStop(stop, startTime, timeRange, arrivalDeparture, includeCancelledTrips, numberOfDepartures, departuresPerLineAndDestinationDisplay, whiteListed.authorityIds, whiteListed.lineIds, transitModes, environment).sorted(TripTimeOnDate.compareByDeparture()).distinct().limit(numberOfDepartures).collect(Collectors.toList());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").description("Get all situations active for the quay.").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).dataFetcher(env -> GqlUtil.getTransitService(env).getTransitAlertService().getStopAlerts(((StopLocation)env.getSource()).getId())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopType").type((GraphQLOutputType)Scalars.GraphQLString).dataFetcher(environment -> {
            StopLocation stopLocation = (StopLocation)environment.getSource();
            if (stopLocation instanceof RegularStop) {
                return "regular";
            }
            if (stopLocation instanceof AreaStop) {
                return "flexible_area";
            }
            if (stopLocation instanceof GroupStop) {
                return "flexible_group";
            }
            return null;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("flexibleArea").description("Geometry for flexible area.").type((GraphQLOutputType)GeoJSONCoordinatesScalar.getGraphQGeoJSONCoordinatesScalar()).dataFetcher(environment -> {
            Coordinate[] coordinateArray;
            Object patt14306$temp = environment.getSource();
            if (patt14306$temp instanceof AreaStop) {
                AreaStop areaStop = (AreaStop)patt14306$temp;
                coordinateArray = areaStop.getGeometry().getCoordinates();
            } else {
                coordinateArray = null;
            }
            return coordinateArray;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("flexibleGroup").description("the Quays part of an flexible group.").type((GraphQLOutputType)GraphQLList.list((GraphQLType)REF)).dataFetcher(environment -> {
            Set<StopLocation> set;
            Object patt14771$temp = environment.getSource();
            if (patt14771$temp instanceof GroupStop) {
                GroupStop groupStop = (GroupStop)patt14771$temp;
                set = groupStop.getLocations();
            } else {
                set = null;
            }
            return set;
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("tariffZones").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)tariffZoneType))).dataFetcher(environment -> ((StopLocation)environment.getSource()).getFareZones()).build()).build();
    }
}

