/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.model.siri.et;

import graphql.Scalars;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.opentripplanner.ext.transmodelapi.model.EnumTypes;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.service.TransitService;

public class EstimatedCallType {
    private static final String NAME = "EstimatedCall";
    public static final GraphQLTypeReference REF = new GraphQLTypeReference("EstimatedCall");

    public static GraphQLObjectType create(GraphQLOutputType bookingArrangementType, GraphQLOutputType noticeType, GraphQLOutputType quayType, GraphQLOutputType destinationDisplayType, GraphQLOutputType ptSituationElementType, GraphQLOutputType serviceJourneyType, GraphQLOutputType datedServiceJourneyType, GqlUtil gqlUtil) {
        return GraphQLObjectType.newObject().name(NAME).description("List of visits to quays as part of vehicle journeys. Updated with real time information where available").field(GraphQLFieldDefinition.newFieldDefinition().name("quay").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)quayType)).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getStop()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("aimedArrivalTime").description("Scheduled time of arrival at quay. Not affected by read time updated").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).dataFetcher(environment -> 1000L * (((TripTimeOnDate)environment.getSource()).getServiceDayMidnight() + (long)((TripTimeOnDate)environment.getSource()).getScheduledArrival())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("expectedArrivalTime").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).description("Expected time of arrival at quay. Updated with real time information if available. Will be null if an actualArrivalTime exists").dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            return 1000L * (tripTimeOnDate.getServiceDayMidnight() + (long)tripTimeOnDate.getRealtimeArrival());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("actualArrivalTime").type((GraphQLOutputType)gqlUtil.dateTimeScalar).description("Actual time of arrival at quay. Updated from real time information if available.").dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            if (tripTimeOnDate.getActualArrival() == -1) {
                return null;
            }
            return 1000L * (tripTimeOnDate.getServiceDayMidnight() + (long)tripTimeOnDate.getActualArrival());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("aimedDepartureTime").description("Scheduled time of departure from quay. Not affected by read time updated").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).dataFetcher(environment -> 1000L * (((TripTimeOnDate)environment.getSource()).getServiceDayMidnight() + (long)((TripTimeOnDate)environment.getSource()).getScheduledDeparture())).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("expectedDepartureTime").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateTimeScalar)).description("Expected time of departure from quay. Updated with real time information if available. Will be null if an actualDepartureTime exists").dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            return 1000L * (tripTimeOnDate.getServiceDayMidnight() + (long)tripTimeOnDate.getRealtimeDeparture());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("actualDepartureTime").type((GraphQLOutputType)gqlUtil.dateTimeScalar).description("Actual time of departure from quay. Updated with real time information if available.").dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            if (tripTimeOnDate.getActualDeparture() == -1) {
                return null;
            }
            return 1000L * (tripTimeOnDate.getServiceDayMidnight() + (long)tripTimeOnDate.getActualDeparture());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("timingPoint").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether this is a timing point or not. Boarding and alighting is not allowed at timing points.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).isTimepoint()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("realtime").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether this call has been updated with real time information.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).isRealtime()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("predictionInaccurate").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether the updated estimates are expected to be inaccurate.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).isPredictionInaccurate()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("realtimeState").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)EnumTypes.REALTIME_STATE)).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getRealtimeState()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("occupancyStatus").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)EnumTypes.OCCUPANCY_STATUS)).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getOccupancyStatus()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("stopPositionInPattern").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLInt)).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getStopIndex()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("forBoarding").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether vehicle may be boarded at quay.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getPickupType().isRoutable()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("forAlighting").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether vehicle may be alighted at quay.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getDropoffType().isRoutable()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("requestStop").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether vehicle will only stop on request.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getDropoffType() == PickDrop.COORDINATE_WITH_DRIVER).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("cancellation").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)Scalars.GraphQLBoolean)).description("Whether stop is cancelled. This means that either the ServiceJourney has a planned cancellation, the ServiceJourney has been cancelled by realtime data, or this particular StopPoint has been cancelled. This also means that both boarding and alighting has been cancelled.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).isCanceledEffectively()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("date").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)gqlUtil.dateScalar)).description("The date the estimated call is valid for.").dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getServiceDay()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("serviceJourney").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)serviceJourneyType)).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getTrip()).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("datedServiceJourney").type(datedServiceJourneyType).dataFetcher(environment -> GqlUtil.getTransitService(environment).getTripOnServiceDateForTripAndDay(new TripIdAndServiceDate(((TripTimeOnDate)environment.getSource()).getTrip().getId(), ((TripTimeOnDate)environment.getSource()).getServiceDay()))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("destinationDisplay").type(destinationDisplayType).dataFetcher(DataFetchingEnvironment::getSource).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("notices").type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)noticeType)))).dataFetcher(environment -> {
            TripTimeOnDate tripTimeOnDate = (TripTimeOnDate)environment.getSource();
            return GqlUtil.getTransitService(environment).getNoticesByEntity(tripTimeOnDate.getStopTimeKey());
        }).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("situations").withDirective(gqlUtil.timingData).type((GraphQLOutputType)new GraphQLNonNull((GraphQLType)new GraphQLList((GraphQLType)new GraphQLNonNull((GraphQLType)ptSituationElementType)))).description("Get all relevant situations for this EstimatedCall.").dataFetcher(environment -> EstimatedCallType.getAllRelevantAlerts((TripTimeOnDate)environment.getSource(), GqlUtil.getTransitService(environment))).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("bookingArrangements").description("Booking arrangements for this EstimatedCall.").type(bookingArrangementType).dataFetcher(environment -> ((TripTimeOnDate)environment.getSource()).getPickupBookingInfo()).build()).build();
    }

    private static Collection<TransitAlert> getAllRelevantAlerts(TripTimeOnDate tripTimeOnDate, TransitService transitService) {
        Trip trip = tripTimeOnDate.getTrip();
        FeedScopedId tripId = trip.getId();
        FeedScopedId routeId = trip.getRoute().getId();
        StopLocation stop = tripTimeOnDate.getStop();
        FeedScopedId stopId = stop.getId();
        FeedScopedId parentStopId = stop.getParentStation().getId();
        HashSet<TransitAlert> allAlerts = new HashSet<TransitAlert>();
        TransitAlertService alertPatchService = transitService.getTransitAlertService();
        LocalDate serviceDate = tripTimeOnDate.getServiceDay();
        Set<StopCondition> stopConditions = Set.of(StopCondition.STOP, StopCondition.START_POINT, StopCondition.EXCEPTIONAL_STOP);
        allAlerts.addAll(alertPatchService.getStopAlerts(stopId, stopConditions));
        allAlerts.addAll(alertPatchService.getStopAndTripAlerts(stopId, tripId, serviceDate, stopConditions));
        allAlerts.addAll(alertPatchService.getStopAndRouteAlerts(stopId, routeId, stopConditions));
        allAlerts.addAll(alertPatchService.getStopAlerts(parentStopId, stopConditions));
        allAlerts.addAll(alertPatchService.getStopAndTripAlerts(parentStopId, tripId, serviceDate, stopConditions));
        allAlerts.addAll(alertPatchService.getStopAndRouteAlerts(parentStopId, routeId, stopConditions));
        allAlerts.addAll(alertPatchService.getTripAlerts(tripId, serviceDate));
        allAlerts.addAll(alertPatchService.getRouteAlerts(routeId));
        allAlerts.addAll(alertPatchService.getAgencyAlerts(trip.getRoute().getAgency().getId()));
        allAlerts.addAll(alertPatchService.getDirectionAndRouteAlerts(trip.getDirection(), routeId));
        long serviceDay = tripTimeOnDate.getServiceDayMidnight();
        long arrivalTime = tripTimeOnDate.getRealtimeArrival();
        long departureTime = tripTimeOnDate.getRealtimeDeparture();
        EstimatedCallType.filterSituationsByDateAndStopConditions(allAlerts, Instant.ofEpochSecond(serviceDay + arrivalTime), Instant.ofEpochSecond(serviceDay + departureTime));
        return allAlerts;
    }

    private static void filterSituationsByDateAndStopConditions(Collection<TransitAlert> alertPatches, Instant fromTime, Instant toTime) {
        if (alertPatches != null) {
            alertPatches.removeIf(alert -> alert.getEffectiveStartDate() != null && alert.getEffectiveStartDate().isAfter(toTime) || alert.getEffectiveEndDate() != null && alert.getEffectiveEndDate().isBefore(fromTime));
            alertPatches.removeIf(alertPatch -> !alertPatch.displayDuring(fromTime.getEpochSecond(), toTime.getEpochSecond()));
        }
    }
}

