/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.transmodelapi.TransmodelRequestContext;
import org.opentripplanner.ext.transmodelapi.mapping.GenericLocationMapper;
import org.opentripplanner.ext.transmodelapi.mapping.ViaLocationMapper;
import org.opentripplanner.ext.transmodelapi.mapping.ViaSegmentMapper;
import org.opentripplanner.framework.graphql.GraphQLUtils;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.RouteViaRequest;
import org.opentripplanner.routing.api.request.ViaLocation;
import org.opentripplanner.routing.api.request.request.JourneyRequest;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

public class ViaRequestMapper {
    public static RouteViaRequest createRouteViaRequest(DataFetchingEnvironment environment) {
        List<JourneyRequest> requests;
        TransmodelRequestContext context = (TransmodelRequestContext)environment.getContext();
        OtpServerRequestContext serverContext = context.getServerContext();
        RouteRequest request = serverContext.defaultRouteRequest();
        List viaInput = (List)environment.getArgument("via");
        List<ViaLocation> vias = viaInput.stream().map(ViaLocationMapper::mapViaLocation).toList();
        if (environment.containsArgument("segments")) {
            List segments = (List)environment.getArgument("segments");
            requests = segments.stream().map(viaRequest -> ViaSegmentMapper.mapViaSegment(request, viaRequest)).toList();
        } else {
            requests = Collections.nCopies(vias.size() + 1, request.journey());
        }
        return RouteViaRequest.of(vias, requests).withDateTime(Instant.ofEpochMilli((Long)environment.getArgumentOrDefault("dateTime", (Object)request.dateTime().toEpochMilli()))).withSearchWindow((Duration)environment.getArgumentOrDefault("searchWindow", (Object)request.searchWindow())).withFrom(GenericLocationMapper.toGenericLocation((Map)environment.getArgument("from"))).withTo(GenericLocationMapper.toGenericLocation((Map)environment.getArgument("to"))).withNumItineraries((Integer)environment.getArgumentOrDefault("numTripPatterns", (Object)request.numItineraries())).withWheelchair((Boolean)environment.getArgumentOrDefault("wheelchairAccessible", (Object)request.wheelchair())).withLocale(GraphQLUtils.getLocale(environment)).build();
    }
}

