/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.transmodelapi.mapping.TransitIdMapper;
import org.opentripplanner.ext.transmodelapi.model.TransmodelTransportSubmode;
import org.opentripplanner.routing.api.request.request.filter.SelectRequest;
import org.opentripplanner.transit.model.basic.MainAndSubMode;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;

class SelectRequestMapper {
    SelectRequestMapper() {
    }

    static SelectRequest mapSelectRequest(Map<String, List<?>> input) {
        SelectRequest.Builder selectRequestBuilder = SelectRequest.of();
        if (input.containsKey("lines")) {
            List<String> lines = input.get("lines");
            selectRequestBuilder.withRoutes(TransitIdMapper.mapIDsToDomain(lines));
        }
        if (input.containsKey("authorities")) {
            List<String> authorities = input.get("authorities");
            selectRequestBuilder.withAgencies(TransitIdMapper.mapIDsToDomain(authorities));
        }
        if (input.containsKey("groupOfLines")) {
            List<String> groupOfLines = input.get("groupOfLines");
            selectRequestBuilder.withGroupOfRoutes(TransitIdMapper.mapIDsToDomain(groupOfLines));
        }
        if (input.containsKey("transportModes")) {
            ArrayList<MainAndSubMode> tModes = new ArrayList<MainAndSubMode>();
            List<?> transportModes = input.get("transportModes");
            for (Map modeWithSubModes : transportModes) {
                TransitMode mainMode = (TransitMode)((Object)modeWithSubModes.get("transportMode"));
                if (modeWithSubModes.containsKey("transportSubModes")) {
                    List transportSubModes = (List)modeWithSubModes.get("transportSubModes");
                    for (TransmodelTransportSubmode subMode : transportSubModes) {
                        tModes.add(new MainAndSubMode(mainMode, SubMode.of(subMode.getValue())));
                    }
                    continue;
                }
                tModes.add(new MainAndSubMode(mainMode));
            }
            selectRequestBuilder.withTransportModes(tModes);
        }
        return selectRequestBuilder.build();
    }
}

