/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.transmodelapi.mapping;

import graphql.schema.DataFetchingEnvironment;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.transmodelapi.model.TransportModeSlack;
import org.opentripplanner.ext.transmodelapi.model.plan.ItineraryFiltersInputType;
import org.opentripplanner.ext.transmodelapi.support.DataFetcherDecorator;
import org.opentripplanner.ext.transmodelapi.support.GqlUtil;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.preference.RoutingPreferences;
import org.opentripplanner.routing.core.BicycleOptimizeType;

class PreferencesMapper {
    PreferencesMapper() {
    }

    static void mapPreferences(DataFetchingEnvironment environment, DataFetcherDecorator callWith, RoutingPreferences.Builder preferences) {
        preferences.withWalk(b -> {
            callWith.argument("walkBoardCost", b::withBoardCost);
            callWith.argument("walkSpeed", b::withSpeed);
        });
        callWith.argument("walkReluctance", streetReluctance -> PreferencesMapper.setStreetReluctance(preferences, streetReluctance));
        if (GqlUtil.hasArgument(environment, "maxAccessEgressDurationForMode")) {
            preferences.withStreet(street -> {
                for (Map entry : (List)environment.getArgument("maxAccessEgressDurationForMode")) {
                    street.withMaxAccessEgressDuration((StreetMode)((Object)((Object)entry.get("streetMode"))), (Duration)entry.get("duration"));
                }
            });
        }
        preferences.withBike(bike -> {
            callWith.argument("bikeSpeed", bike::withSpeed);
            callWith.argument("bikeSwitchTime", bike::withSwitchTime);
            callWith.argument("bikeSwitchCost", bike::withSwitchCost);
            callWith.argument("bicycleOptimisationMethod", bike::withOptimizeType);
            if (bike.optimizeType() == BicycleOptimizeType.TRIANGLE) {
                bike.withOptimizeTriangle(triangle -> {
                    callWith.argument("triangle.timeFactor", triangle::withTime);
                    callWith.argument("triangle.slopeFactor", triangle::withSlope);
                    callWith.argument("triangle.safetyFactor", triangle::withSafety);
                });
            }
        });
        preferences.withTransfer(transfer -> {
            callWith.argument("transferPenalty", transfer::withCost);
            callWith.argument("minimumTransferTime", transfer::withSlack);
            callWith.argument("transferSlack", transfer::withSlack);
            callWith.argument("waitReluctance", transfer::withWaitReluctance);
            callWith.argument("maximumTransfers", transfer::withMaxTransfers);
            callWith.argument("maximumAdditionalTransfers", transfer::withMaxAdditionalTransfers);
        });
        preferences.withTransit(tr -> {
            callWith.argument("preferred.otherThanPreferredLinesPenalty", tr::setOtherThanPreferredRoutesPenalty);
            tr.withBoardSlack(builder -> {
                callWith.argument("boardSlackDefault", builder::withDefaultSec);
                callWith.argument("boardSlackList", v -> TransportModeSlack.mapIntoDomain(builder, v));
            });
            tr.withAlightSlack(builder -> {
                callWith.argument("alightSlackDefault", builder::withDefaultSec);
                callWith.argument("alightSlackList", v -> TransportModeSlack.mapIntoDomain(builder, v));
            });
            callWith.argument("ignoreRealtimeUpdates", tr::setIgnoreRealtimeUpdates);
            callWith.argument("includePlannedCancellations", tr::setIncludePlannedCancellations);
            callWith.argument("includeRealtimeCancellations", tr::setIncludeRealtimeCancellations);
            callWith.argument("relaxTransitSearchGeneralizedCostAtDestination", value -> tr.withRaptor(it -> it.withRelaxGeneralizedCostAtDestination((Double)value)));
        });
        preferences.withItineraryFilter(itineraryFilter -> {
            callWith.argument("debugItineraryFilter", itineraryFilter::withDebug);
            ItineraryFiltersInputType.mapToRequest(environment, callWith, itineraryFilter);
        });
        preferences.withRental(rental -> callWith.argument("useBikeRentalAvailabilityInformation", rental::withUseAvailabilityInformation));
    }

    private static void setStreetReluctance(RoutingPreferences.Builder preferences, Double streetReluctance) {
        if (streetReluctance > 0.0) {
            preferences.withWalk(walk -> walk.withReluctance(streetReluctance));
            preferences.withBike(bike -> bike.withReluctance(streetReluctance).withWalkingReluctance(streetReluctance * 2.7));
            preferences.withCar(car -> car.withReluctance(streetReluctance));
        }
    }
}

