/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.smoovebikerental;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.opentripplanner.ext.smoovebikerental.SmooveBikeRentalDataSourceParameters;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.service.vehiclerental.model.RentalVehicleType;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStation;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.updater.spi.GenericJsonDataSource;
import org.opentripplanner.updater.vehicle_rental.datasources.VehicleRentalDatasource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmooveBikeRentalDataSource
extends GenericJsonDataSource<VehicleRentalPlace>
implements VehicleRentalDatasource {
    private static final Logger log = LoggerFactory.getLogger(SmooveBikeRentalDataSource.class);
    public static final String DEFAULT_NETWORK_NAME = "smoove";
    private final boolean overloadingAllowed;
    private final String networkName;
    private final RentalVehicleType vehicleType;

    public SmooveBikeRentalDataSource(SmooveBikeRentalDataSourceParameters config) {
        super(config.url(), "result", config.httpHeaders());
        this.networkName = config.getNetwork(DEFAULT_NETWORK_NAME);
        this.vehicleType = RentalVehicleType.getDefaultType(this.networkName);
        this.overloadingAllowed = config.overloadingAllowed();
    }

    @Override
    protected VehicleRentalStation parseElement(JsonNode node) {
        VehicleRentalStation station = new VehicleRentalStation();
        String[] nameParts = node.path("name").asText().split("\\s", 2);
        station.id = new FeedScopedId(this.networkName, nameParts[0]);
        station.name = new NonLocalizedString(nameParts[1]);
        String[] coordinates = node.path("coordinates").asText().split(",");
        try {
            station.latitude = Double.parseDouble(coordinates[0].trim());
            station.longitude = Double.parseDouble(coordinates[1].trim());
        }
        catch (NumberFormatException e) {
            log.warn("Error parsing bike rental station {}", (Object)station.id, (Object)e);
            return null;
        }
        if (!node.path("style").asText().equals("Station on")) {
            station.isRenting = false;
            station.isReturning = false;
            station.vehiclesAvailable = 0;
            station.spacesAvailable = 0;
            station.capacity = node.path("total_slots").asInt();
        } else {
            station.vehiclesAvailable = node.path("avl_bikes").asInt();
            station.spacesAvailable = node.path("free_slots").asInt();
            station.capacity = node.path("total_slots").asInt();
        }
        station.vehicleTypesAvailable = Map.of(this.vehicleType, station.vehiclesAvailable);
        station.vehicleSpacesAvailable = Map.of(this.vehicleType, station.spacesAvailable);
        station.overloadingAllowed = this.overloadingAllowed;
        return station;
    }
}

