/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.opentripplanner.ext.siri.SiriAlertsUpdateHandler;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.updater.SiriSXUpdaterParameters;
import org.opentripplanner.routing.impl.TransitAlertServiceImpl;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.alert.TransitAlertProvider;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.opentripplanner.updater.spi.PollingGraphUpdater;
import org.opentripplanner.updater.spi.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;

public class SiriSXUpdater
extends PollingGraphUpdater
implements TransitAlertProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SiriSXUpdater.class);
    private static final long RETRY_INTERVAL_MILLIS = 5000L;
    private final String url;
    private final String originalRequestorRef;
    private final TransitAlertService transitAlertService;
    private final SiriAlertsUpdateHandler updateHandler;
    private final HttpHeaders requestHeaders;
    private WriteToGraphCallback saveResultOnGraph;
    private ZonedDateTime lastTimestamp = ZonedDateTime.now().minusWeeks(1L);
    private String requestorRef;
    private int timeout;
    private int retryCount = 0;

    public SiriSXUpdater(SiriSXUpdaterParameters config, TransitModel transitModel) {
        super(config);
        this.url = config.getUrl();
        this.requestorRef = config.getRequestorRef();
        if (this.requestorRef == null || this.requestorRef.isEmpty()) {
            this.requestorRef = "otp-" + UUID.randomUUID().toString();
        }
        this.originalRequestorRef = this.requestorRef;
        int timeoutSec = config.getTimeoutSec();
        if (timeoutSec > 0) {
            this.timeout = 1000 * timeoutSec;
        }
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        this.requestHeaders = config.requestHeaders();
        this.transitAlertService = new TransitAlertServiceImpl(transitModel);
        this.updateHandler = new SiriAlertsUpdateHandler(config.getFeedId(), transitModel, this.transitAlertService, SiriFuzzyTripMatcher.of(new DefaultTransitService(transitModel)), config.getEarlyStartSec());
        LOG.info("Creating real-time alert updater (SIRI SX) running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.url);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public TransitAlertService getTransitAlertService() {
        return this.transitAlertService;
    }

    public String toString() {
        return "SiriSXUpdater (" + this.url + ")";
    }

    @Override
    protected void runPolling() {
        try {
            boolean moreData = false;
            do {
                boolean markPrimed;
                Siri updates;
                if ((updates = this.getUpdates()) == null) continue;
                ServiceDelivery serviceDelivery = updates.getServiceDelivery();
                moreData = Boolean.TRUE.equals(serviceDelivery.isMoreData());
                boolean bl = markPrimed = !moreData;
                if (serviceDelivery.getSituationExchangeDeliveries() == null) continue;
                this.saveResultOnGraph.execute((graph, transitModel) -> {
                    this.updateHandler.update(serviceDelivery);
                    if (markPrimed) {
                        this.primed = true;
                    }
                });
            } while (moreData);
        }
        catch (IOException e) {
            long sleepTime = 5000L + 5000L * (long)this.retryCount;
            ++this.retryCount;
            LOG.info("Caught timeout - retry no. {} after {} millis", (Object)this.retryCount, (Object)sleepTime);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.requestorRef = this.originalRequestorRef + "-retry-" + this.retryCount;
            this.runPolling();
        }
    }

    /*
     * Exception decompiling
     */
    private Siri getUpdates() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

