/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.opentripplanner.ext.siri.SiriHttpUtils;
import org.opentripplanner.ext.siri.updater.EstimatedTimetableSource;
import org.opentripplanner.ext.siri.updater.SiriHelper;
import org.opentripplanner.updater.spi.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.Siri;

public class SiriETHttpTripUpdateSource
implements EstimatedTimetableSource {
    private static final Logger LOG = LoggerFactory.getLogger(SiriETHttpTripUpdateSource.class);
    private final String feedId;
    private final String url;
    private final String requestorRef;
    private final int timeout;
    private final int previewIntervalMillis;
    private final HttpHeaders requestHeaders;
    private boolean fullDataset = true;
    private ZonedDateTime lastTimestamp = ZonedDateTime.now().minusMonths(1L);

    public SiriETHttpTripUpdateSource(Parameters parameters) {
        this.feedId = parameters.getFeedId();
        this.url = parameters.getUrl();
        this.requestHeaders = parameters.httpRequestHeaders();
        this.requestorRef = parameters.getRequestorRef() == null || parameters.getRequestorRef().isEmpty() ? "otp-" + UUID.randomUUID() : parameters.getRequestorRef();
        this.timeout = parameters.getTimeoutSec() > 0 ? 1000 * parameters.getTimeoutSec() : -1;
        int min = parameters.getPreviewIntervalMinutes();
        this.previewIntervalMillis = min > 0 ? 60000 * min : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Siri getUpdates() {
        block10: {
            long unmarshalling;
            long fetching;
            long creating;
            long t1;
            block8: {
                Siri siri;
                block9: {
                    t1 = System.currentTimeMillis();
                    creating = 0L;
                    fetching = 0L;
                    unmarshalling = 0L;
                    String etServiceRequest = SiriHelper.createETServiceRequestAsXml(this.requestorRef, this.previewIntervalMillis);
                    creating = System.currentTimeMillis() - t1;
                    t1 = System.currentTimeMillis();
                    InputStream is = SiriHttpUtils.postData(this.url, etServiceRequest, this.timeout, this.requestHeaders.asMap());
                    if (is == null) break block8;
                    fetching = System.currentTimeMillis() - t1;
                    t1 = System.currentTimeMillis();
                    siri = SiriHelper.unmarshal(is);
                    unmarshalling = System.currentTimeMillis() - t1;
                    if (!siri.getServiceDelivery().getResponseTimestamp().isBefore(this.lastTimestamp)) break block9;
                    LOG.info("Newer data has already been processed");
                    Siri siri2 = null;
                    LOG.info("Updating ET [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
                    return siri2;
                }
                this.lastTimestamp = siri.getServiceDelivery().getResponseTimestamp();
                this.fullDataset = false;
                Siri siri3 = siri;
                LOG.info("Updating ET [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
                return siri3;
            }
            try {
                LOG.error("Could not fetch SIRI-ET data from {}", (Object)this.url);
            }
            catch (IOException e) {
                LOG.info("Failed after {} ms", (Object)(System.currentTimeMillis() - t1));
                LOG.warn("Could not get SIRI-ET data from {}", (Object)this.url, (Object)e);
                LOG.info("Updating ET [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
                break block10;
            }
            catch (Exception e2) {
                LOG.info("Failed after {} ms", (Object)(System.currentTimeMillis() - t1));
                LOG.warn("Failed to parse SIRI-ET feed from {}", (Object)this.url, (Object)e2);
                {
                    catch (Throwable throwable) {
                        LOG.info("Updating ET [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
                        throw throwable;
                    }
                }
                LOG.info("Updating ET [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
            }
            LOG.info("Updating ET [{}]: Create req: {}, Fetching data: {}, Unmarshalling: {}", new Object[]{this.requestorRef, creating, fetching, unmarshalling});
        }
        return null;
    }

    @Override
    public boolean getFullDatasetValueOfLastUpdates() {
        return this.fullDataset;
    }

    @Override
    public String getFeedId() {
        return this.feedId;
    }

    public String toString() {
        return "SiriETHttpTripUpdateSource(" + this.url + ")";
    }

    public static interface Parameters {
        public String getUrl();

        public String getRequestorRef();

        public String getFeedId();

        public int getTimeoutSec();

        public int getPreviewIntervalMinutes();

        public HttpHeaders httpRequestHeaders();
    }
}

