/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.mapper;

import java.util.Optional;
import org.opentripplanner.ext.siri.CallWrapper;
import org.opentripplanner.model.PickDrop;
import uk.org.siri.siri20.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri20.CallStatusEnumeration;
import uk.org.siri.siri20.DepartureBoardingActivityEnumeration;

public class PickDropMapper {
    public static Optional<PickDrop> mapDropOffType(CallWrapper call, PickDrop currentValue) {
        if (PickDropMapper.shouldBeCancelled(currentValue, call.isCancellation(), call.getArrivalStatus())) {
            return Optional.of(PickDrop.CANCELLED);
        }
        ArrivalBoardingActivityEnumeration arrivalBoardingActivityEnumeration = call.getArrivalBoardingActivity();
        if (arrivalBoardingActivityEnumeration == null) {
            return Optional.empty();
        }
        return switch (arrivalBoardingActivityEnumeration) {
            default -> throw new IncompatibleClassChangeError();
            case ArrivalBoardingActivityEnumeration.ALIGHTING -> {
                if (currentValue.isNotRoutable()) {
                    yield Optional.of(PickDrop.SCHEDULED);
                }
                yield Optional.empty();
            }
            case ArrivalBoardingActivityEnumeration.NO_ALIGHTING -> Optional.of(PickDrop.NONE);
            case ArrivalBoardingActivityEnumeration.PASS_THRU -> Optional.of(PickDrop.CANCELLED);
        };
    }

    public static Optional<PickDrop> mapPickUpType(CallWrapper call, PickDrop currentValue) {
        if (PickDropMapper.shouldBeCancelled(currentValue, call.isCancellation(), call.getDepartureStatus())) {
            return Optional.of(PickDrop.CANCELLED);
        }
        DepartureBoardingActivityEnumeration departureBoardingActivityEnumeration = call.getDepartureBoardingActivity();
        if (departureBoardingActivityEnumeration == null) {
            return Optional.empty();
        }
        return switch (departureBoardingActivityEnumeration) {
            default -> throw new IncompatibleClassChangeError();
            case DepartureBoardingActivityEnumeration.BOARDING -> {
                if (currentValue.isNotRoutable()) {
                    yield Optional.of(PickDrop.SCHEDULED);
                }
                yield Optional.empty();
            }
            case DepartureBoardingActivityEnumeration.NO_BOARDING -> Optional.of(PickDrop.NONE);
            case DepartureBoardingActivityEnumeration.PASS_THRU -> Optional.of(PickDrop.CANCELLED);
        };
    }

    private static boolean shouldBeCancelled(PickDrop currentValue, Boolean isCallCancellation, CallStatusEnumeration callStatus) {
        if (currentValue.isNotRoutable()) {
            return false;
        }
        return Boolean.TRUE.equals(isCallCancellation) || callStatus == CallStatusEnumeration.CANCELLED;
    }
}

