/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.siri.CallWrapper;
import org.opentripplanner.ext.siri.EntityResolver;
import org.opentripplanner.ext.siri.TripAndPattern;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.calendar.CalendarService;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.MonitoredVehicleJourneyStructure;
import uk.org.siri.siri20.VehicleModesEnumeration;

public class SiriFuzzyTripMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SiriFuzzyTripMatcher.class);
    private static SiriFuzzyTripMatcher instance;
    private final Map<String, Set<Trip>> internalPlanningCodeCache = new HashMap<String, Set<Trip>>();
    private final Map<String, Set<Trip>> startStopTripCache = new HashMap<String, Set<Trip>>();
    private final TransitService transitService;
    private boolean initialized = false;

    public static SiriFuzzyTripMatcher of(TransitService transitService) {
        if (instance == null) {
            instance = new SiriFuzzyTripMatcher(transitService);
        }
        return instance;
    }

    private SiriFuzzyTripMatcher(TransitService transitService) {
        this.transitService = transitService;
        this.initCache(this.transitService);
    }

    public Trip match(MonitoredVehicleJourneyStructure monitoredVehicleJourney, EntityResolver entityResolver) {
        if (monitoredVehicleJourney.getDestinationRef() != null) {
            String destinationRef = monitoredVehicleJourney.getDestinationRef().getValue();
            ZonedDateTime arrivalTime = monitoredVehicleJourney.getDestinationAimedArrivalTime();
            if (arrivalTime != null) {
                Set<Trip> trips = this.getMatchingTripsOnStopOrSiblings(destinationRef, arrivalTime, entityResolver);
                if (trips.isEmpty()) {
                    return null;
                }
                return this.getTripForJourney(trips, monitoredVehicleJourney);
            }
        }
        return null;
    }

    public TripAndPattern match(EstimatedVehicleJourney journey, EntityResolver entityResolver, BiFunction<TripPattern, LocalDate, Timetable> getCurrentTimetable, BiFunction<FeedScopedId, LocalDate, TripPattern> getRealtimeAddedTripPattern) {
        String lineRef;
        Route route;
        List<CallWrapper> calls = CallWrapper.of(journey);
        if (calls.isEmpty()) {
            return null;
        }
        Set<Trip> trips = null;
        if (journey.getVehicleRef() != null && journey.getVehicleModes().contains(VehicleModesEnumeration.RAIL)) {
            trips = this.getCachedTripsByInternalPlanningCode(journey.getVehicleRef().getValue());
        }
        if (trips == null || trips.isEmpty()) {
            ZonedDateTime arrivalTime;
            CallWrapper lastStop = calls.get(calls.size() - 1);
            String lastStopPoint = lastStop.getStopPointRef();
            ZonedDateTime zonedDateTime = arrivalTime = lastStop.getAimedArrivalTime() != null ? lastStop.getAimedArrivalTime() : lastStop.getAimedDepartureTime();
            if (arrivalTime != null) {
                trips = this.getMatchingTripsOnStopOrSiblings(lastStopPoint, arrivalTime, entityResolver);
            }
        }
        if (trips == null || trips.isEmpty()) {
            return null;
        }
        if (journey.getLineRef() != null && (route = entityResolver.resolveRoute(lineRef = journey.getLineRef().getValue())) != null) {
            trips = trips.stream().filter(trip -> trip.getRoute().equals(route)).collect(Collectors.toSet());
        }
        return this.getTripAndPatternForJourney(trips, calls, entityResolver, getCurrentTimetable, getRealtimeAddedTripPattern);
    }

    public List<FeedScopedId> getTripIdForInternalPlanningCodeServiceDate(String internalPlanningCode, LocalDate serviceDate) {
        ArrayList<FeedScopedId> matches = new ArrayList<FeedScopedId>();
        for (Trip trip : this.getCachedTripsByInternalPlanningCode(internalPlanningCode)) {
            Set<LocalDate> serviceDates = this.transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
            if (!serviceDates.contains(serviceDate)) continue;
            matches.add(trip.getId());
        }
        return matches;
    }

    private void initCache(TransitService index) {
        if (!this.initialized) {
            for (Trip trip : index.getAllTrips()) {
                String internalPlanningCode;
                TripPattern tripPattern = index.getPatternForTrip(trip);
                if (tripPattern == null) continue;
                if (tripPattern.getRoute().getMode().equals((Object)TransitMode.RAIL) && (internalPlanningCode = trip.getNetexInternalPlanningCode()) != null) {
                    this.internalPlanningCodeCache.computeIfAbsent(internalPlanningCode, key -> new HashSet()).add(trip);
                }
                String lastStopId = tripPattern.lastStop().getId().getId();
                TripTimes tripTimes = tripPattern.getScheduledTimetable().getTripTimes(trip);
                if (tripTimes == null) continue;
                int arrivalTime = tripTimes.getArrivalTime(tripTimes.getNumStops() - 1);
                String key2 = SiriFuzzyTripMatcher.createStartStopKey(lastStopId, arrivalTime);
                this.startStopTripCache.computeIfAbsent(key2, k -> new HashSet()).add(trip);
            }
            LOG.info("Built internalPlanningCode-cache [{}].", (Object)this.internalPlanningCodeCache.size());
            LOG.info("Built start-stop-cache [{}].", (Object)this.startStopTripCache.size());
        }
        this.initialized = true;
    }

    private static String createStartStopKey(String lastStopId, int lastStopArrivalTime) {
        return lastStopId + ":" + lastStopArrivalTime;
    }

    @Nonnull
    private Set<Trip> getMatchingTripsOnStopOrSiblings(String lastStopPoint, ZonedDateTime arrivalTime, EntityResolver entityResolver) {
        int secondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService(arrivalTime, arrivalTime, this.transitService.getTimeZone());
        int secondsSinceMidnightYesterday = ServiceDateUtils.secondsSinceStartOfService(arrivalTime.minusDays(1L), arrivalTime, this.transitService.getTimeZone());
        Set<Trip> trips = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStopPoint, secondsSinceMidnight));
        if (trips == null) {
            trips = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStopPoint, secondsSinceMidnightYesterday));
        }
        if (trips != null) {
            return trips;
        }
        RegularStop stop = entityResolver.resolveQuay(lastStopPoint);
        if (stop == null || !stop.isPartOfStation()) {
            return Set.of();
        }
        trips = new HashSet<Trip>();
        Collection<StopLocation> allQuays = stop.getParentStation().getChildStops();
        for (StopLocation quay : allQuays) {
            Set<Trip> tripSet = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(quay.getId().getId(), secondsSinceMidnight));
            if (tripSet == null) continue;
            trips.addAll(tripSet);
        }
        return trips;
    }

    private Set<Trip> getCachedTripsByInternalPlanningCode(String internalPlanningCode) {
        if (internalPlanningCode == null) {
            return null;
        }
        return this.internalPlanningCodeCache.getOrDefault(internalPlanningCode, new HashSet());
    }

    private TripAndPattern getTripAndPatternForJourney(Set<Trip> trips, List<CallWrapper> calls, EntityResolver entityResolver, BiFunction<TripPattern, LocalDate, Timetable> getCurrentTimetable, BiFunction<FeedScopedId, LocalDate, TripPattern> getRealtimeAddedTripPattern) {
        RegularStop journeyFirstStop = entityResolver.resolveQuay(calls.get(0).getStopPointRef());
        RegularStop journeyLastStop = entityResolver.resolveQuay(calls.get(calls.size() - 1).getStopPointRef());
        if (journeyFirstStop == null || journeyLastStop == null) {
            return null;
        }
        ZonedDateTime date = calls.get(0).getAimedDepartureTime();
        LocalDate serviceDate = date.toLocalDate();
        int departureInSecondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService(date, date, this.transitService.getTimeZone());
        CalendarService calendarService = this.transitService.getCalendarService();
        HashSet<TripAndPattern> possibleTrips = new HashSet<TripAndPattern>();
        for (Trip trip : trips) {
            TripTimes times;
            boolean lastStopIsMatch;
            if (!calendarService.getServiceDatesForServiceId(trip.getServiceId()).contains(serviceDate)) continue;
            TripPattern realtimeAddedTripPattern = getRealtimeAddedTripPattern.apply(trip.getId(), serviceDate);
            TripPattern tripPattern = realtimeAddedTripPattern != null ? realtimeAddedTripPattern : this.transitService.getPatternForTrip(trip);
            StopLocation firstStop = tripPattern.firstStop();
            StopLocation lastStop = tripPattern.lastStop();
            boolean firstStopIsMatch = firstStop.equals(journeyFirstStop) || firstStop.isPartOfSameStationAs(journeyFirstStop);
            boolean bl = lastStopIsMatch = lastStop.equals(journeyLastStop) || lastStop.isPartOfSameStationAs(journeyLastStop);
            if (!firstStopIsMatch || !lastStopIsMatch || (times = getCurrentTimetable.apply(tripPattern, serviceDate).getTripTimes(trip)) == null || times.getScheduledDepartureTime(0) != departureInSecondsSinceMidnight) continue;
            possibleTrips.add(new TripAndPattern(times.getTrip(), tripPattern));
        }
        if (possibleTrips.isEmpty()) {
            return null;
        }
        if (possibleTrips.size() > 1) {
            LOG.warn("Multiple trip and pattern combinations found, skipping all, {}", possibleTrips);
            return null;
        }
        return (TripAndPattern)possibleTrips.iterator().next();
    }

    private Trip getTripForJourney(Set<Trip> trips, MonitoredVehicleJourneyStructure monitoredVehicleJourney) {
        ZonedDateTime date = monitoredVehicleJourney.getOriginAimedDepartureTime();
        if (date == null) {
            date = ZonedDateTime.now();
        }
        LocalDate serviceDate = date.toLocalDate();
        ArrayList<Trip> results = new ArrayList<Trip>();
        for (Trip trip : trips) {
            Set<LocalDate> serviceDatesForServiceId = this.transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
            for (LocalDate next : serviceDatesForServiceId) {
                if (!next.equals(serviceDate)) continue;
                results.add(trip);
            }
        }
        if (results.size() == 1) {
            return (Trip)results.get(0);
        }
        if (results.size() > 1) {
            if (monitoredVehicleJourney.getLineRef() != null && monitoredVehicleJourney.getLineRef().getValue() != null) {
                String lineRef = monitoredVehicleJourney.getLineRef().getValue();
                for (Trip trip : results) {
                    if (!lineRef.equals(trip.getRoute().getId().getId())) continue;
                    return trip;
                }
            }
            return (Trip)results.get(0);
        }
        return null;
    }
}

