/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.mapper.AffectsMapper;
import org.opentripplanner.ext.siri.mapper.SiriSeverityMapper;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.i18n.TranslatedString;
import org.opentripplanner.routing.alertpatch.AlertUrl;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TimePeriod;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.alertpatch.TransitAlertBuilder;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.DefaultedTextStructure;
import uk.org.siri.siri20.HalfOpenTimestampOutputRangeStructure;
import uk.org.siri.siri20.InfoLinkStructure;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.PtSituationElement;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.SituationExchangeDeliveryStructure;
import uk.org.siri.siri20.WorkflowStatusEnumeration;

public class SiriAlertsUpdateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SiriAlertsUpdateHandler.class);
    private final String feedId;
    private final Set<TransitAlert> alerts = new HashSet<TransitAlert>();
    private final TransitAlertService transitAlertService;
    private final long earlyStart;
    private final AffectsMapper affectsMapper;

    public SiriAlertsUpdateHandler(String feedId, TransitModel transitModel, TransitAlertService transitAlertService, SiriFuzzyTripMatcher siriFuzzyTripMatcher, long earlyStart) {
        this.feedId = feedId;
        this.transitAlertService = transitAlertService;
        this.earlyStart = earlyStart;
        DefaultTransitService transitService = new DefaultTransitService(transitModel);
        this.affectsMapper = new AffectsMapper(feedId, siriFuzzyTripMatcher, transitService);
    }

    public void update(ServiceDelivery delivery) {
        for (SituationExchangeDeliveryStructure sxDelivery : delivery.getSituationExchangeDeliveries()) {
            SituationExchangeDeliveryStructure.Situations situations = sxDelivery.getSituations();
            if (situations == null) continue;
            long t1 = System.currentTimeMillis();
            int addedCounter = 0;
            int expiredCounter = 0;
            for (PtSituationElement sxElement : situations.getPtSituationElements()) {
                boolean expireSituation;
                boolean bl = expireSituation = sxElement.getProgress() != null && sxElement.getProgress().equals((Object)WorkflowStatusEnumeration.CLOSED);
                if (sxElement.getSituationNumber() == null) continue;
                String situationNumber = sxElement.getSituationNumber().getValue();
                FeedScopedId id = new FeedScopedId(this.feedId, situationNumber);
                if (expireSituation) {
                    this.alerts.removeIf(transitAlert -> transitAlert.getId().equals(id));
                    ++expiredCounter;
                    continue;
                }
                TransitAlert alert = null;
                try {
                    alert = this.handleAlert(sxElement);
                    ++addedCounter;
                }
                catch (Exception e) {
                    LOG.info("Caught exception when processing situation with situationNumber {}: {}", (Object)situationNumber, (Object)e);
                }
                if (alert == null) continue;
                this.alerts.removeIf(transitAlert -> transitAlert.getId().equals(id));
                this.alerts.add(alert);
            }
            this.transitAlertService.setAlerts(this.alerts);
            LOG.info("Added {} alerts, expired {} alerts based on {} situations, current alert-count: {}, elapsed time {}ms", new Object[]{addedCounter, expiredCounter, situations.getPtSituationElements().size(), this.transitAlertService.getAllAlerts().size(), System.currentTimeMillis() - t1});
        }
    }

    private TransitAlert handleAlert(PtSituationElement situation) {
        TransitAlertBuilder alert = this.createAlertWithTexts(situation);
        if (!(alert.headerText() != null && !alert.headerText().toString().isEmpty() || alert.descriptionText() != null && !alert.descriptionText().toString().isEmpty() || alert.detailText() != null && !alert.detailText().toString().isEmpty())) {
            LOG.debug("Empty Alert - ignoring situationNumber: {}", situation.getSituationNumber() != null ? situation.getSituationNumber().getValue() : null);
            return null;
        }
        if (situation.getCreationTime() != null) {
            alert.withCreationTime(situation.getCreationTime());
        }
        if (situation.getVersionedAtTime() != null) {
            alert.withUpdatedTime(situation.getVersionedAtTime());
        }
        ArrayList<TimePeriod> periods = new ArrayList<TimePeriod>();
        if (situation.getValidityPeriods().size() > 0) {
            for (HalfOpenTimestampOutputRangeStructure activePeriod : situation.getValidityPeriods()) {
                long realStart = activePeriod.getStartTime() != null ? this.getEpochSecond(activePeriod.getStartTime()) : 0L;
                long start = activePeriod.getStartTime() != null ? realStart - this.earlyStart : 0L;
                long realEnd = activePeriod.getEndTime() != null ? this.getEpochSecond(activePeriod.getEndTime()) : Long.MAX_VALUE;
                long end = activePeriod.getEndTime() != null ? realEnd : Long.MAX_VALUE;
                periods.add(new TimePeriod(start, end));
            }
        } else {
            periods.add(new TimePeriod(0L, Long.MAX_VALUE));
        }
        alert.addTimePeriods(periods);
        if (situation.getPriority() != null) {
            alert.withPriority(situation.getPriority().intValue());
        }
        alert.addEntites(this.affectsMapper.mapAffects(situation.getAffects()));
        if (alert.entities().isEmpty()) {
            LOG.info("No match found for Alert - setting Unknown entity for situation with situationNumber {}", (Object)alert.getId());
            alert.addEntity(new EntitySelector.Unknown("Alert had no entities that could be handled"));
        }
        alert.withType(situation.getReportType());
        alert.withSeverity(SiriSeverityMapper.getAlertSeverityForSiriSeverity(situation.getSeverity()));
        if (situation.getParticipantRef() != null) {
            alert.withSiriCodespace(situation.getParticipantRef().getValue());
        }
        return (TransitAlert)alert.build();
    }

    private long getEpochSecond(ZonedDateTime startTime) {
        return startTime.toEpochSecond();
    }

    private TransitAlertBuilder createAlertWithTexts(PtSituationElement situation) {
        return TransitAlert.of(new FeedScopedId(this.feedId, situation.getSituationNumber().getValue())).withDescriptionText(this.getTranslatedString(situation.getDescriptions())).withDetailText(this.getTranslatedString(situation.getDetails())).withAdviceText(this.getTranslatedString(situation.getAdvices())).withHeaderText(this.getTranslatedString(situation.getSummaries())).withUrl(this.getInfoLinkAsString(situation.getInfoLinks())).addSiriUrls(this.getInfoLinks(situation.getInfoLinks()));
    }

    private I18NString getInfoLinkAsString(PtSituationElement.InfoLinks infoLinks) {
        InfoLinkStructure infoLinkStructure;
        if (infoLinks != null && this.isNotEmpty(infoLinks.getInfoLinks()) && (infoLinkStructure = (InfoLinkStructure)infoLinks.getInfoLinks().get(0)) != null && infoLinkStructure.getUri() != null) {
            return new NonLocalizedString(infoLinkStructure.getUri());
        }
        return null;
    }

    private List<AlertUrl> getInfoLinks(PtSituationElement.InfoLinks infoLinks) {
        ArrayList<AlertUrl> alertUrls = new ArrayList<AlertUrl>();
        if (infoLinks != null && this.isNotEmpty(infoLinks.getInfoLinks())) {
            for (InfoLinkStructure infoLink : infoLinks.getInfoLinks()) {
                AlertUrl alertUrl = new AlertUrl();
                List labels = infoLink.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    NaturalLanguageStringStructure label = (NaturalLanguageStringStructure)labels.get(0);
                    alertUrl.label = label.getValue();
                }
                alertUrl.uri = infoLink.getUri();
                alertUrls.add(alertUrl);
            }
        }
        return alertUrls;
    }

    private boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private I18NString getTranslatedString(List<DefaultedTextStructure> input) {
        HashMap<String, String> translations = new HashMap<String, String>();
        if (input != null && input.size() > 0) {
            for (DefaultedTextStructure textStructure : input) {
                String language = "";
                String value = "";
                if (textStructure.getLang() != null) {
                    language = textStructure.getLang();
                }
                if (textStructure.getValue() != null) {
                    value = textStructure.getValue();
                }
                translations.put(language, value);
            }
        } else {
            translations.put("", "");
        }
        return translations.isEmpty() ? null : TranslatedString.getI18NString(translations, false, true);
    }
}

