/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Objects;
import org.opentripplanner.ext.siri.CallWrapper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripIdAndServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripOnServiceDateBuilder;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.DataFrameRefStructure;
import uk.org.siri.siri20.DatedVehicleJourneyRef;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri20.MonitoredVehicleJourneyStructure;
import uk.org.siri.siri20.VehicleJourneyRef;

public class EntityResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EntityResolver.class);
    private final TransitService transitService;
    private final String feedId;

    public EntityResolver(TransitService transitService, String feedId) {
        this.transitService = transitService;
        this.feedId = feedId;
    }

    public FeedScopedId resolveId(String entityId) {
        return new FeedScopedId(this.feedId, entityId);
    }

    public Trip resolveTrip(EstimatedVehicleJourney journey) {
        Trip addedTrip;
        String datedServiceJourneyId;
        TripOnServiceDate tripOnServiceDate;
        Trip trip = this.resolveTrip(journey.getFramedVehicleJourneyRef());
        if (trip != null) {
            return trip;
        }
        if (journey.getDatedVehicleJourneyRef() != null && (tripOnServiceDate = this.transitService.getTripOnServiceDateById(this.resolveId(datedServiceJourneyId = journey.getDatedVehicleJourneyRef().getValue()))) != null) {
            return tripOnServiceDate.getTrip();
        }
        if (journey.getEstimatedVehicleJourneyCode() != null && (addedTrip = this.transitService.getTripForId(this.resolveId(journey.getEstimatedVehicleJourneyCode()))) != null) {
            return addedTrip;
        }
        return null;
    }

    public Trip resolveTrip(MonitoredVehicleJourneyStructure journey) {
        return this.resolveTrip(journey.getFramedVehicleJourneyRef());
    }

    public TripOnServiceDate resolveTripOnServiceDate(EstimatedVehicleJourney estimatedVehicleJourney) {
        FeedScopedId datedServiceJourneyId = this.resolveDatedServiceJourneyId(estimatedVehicleJourney);
        if (datedServiceJourneyId != null) {
            return this.resolveTripOnServiceDate(datedServiceJourneyId);
        }
        return this.resolveTripOnServiceDate(estimatedVehicleJourney.getFramedVehicleJourneyRef());
    }

    public TripOnServiceDate resolveTripOnServiceDate(String datedServiceJourneyId) {
        return this.resolveTripOnServiceDate(this.resolveId(datedServiceJourneyId));
    }

    public TripOnServiceDate resolveTripOnServiceDate(FramedVehicleJourneyRefStructure framedVehicleJourney) {
        return this.resolveTripOnServiceDate(framedVehicleJourney.getDatedVehicleJourneyRef(), this.resolveServiceDate(framedVehicleJourney));
    }

    public TripOnServiceDate resolveTripOnServiceDate(String serviceJourneyId, LocalDate serviceDate) {
        if (serviceDate == null) {
            return null;
        }
        return this.transitService.getTripOnServiceDateForTripAndDay(new TripIdAndServiceDate(this.resolveId(serviceJourneyId), serviceDate));
    }

    public TripOnServiceDate resolveTripOnServiceDate(FeedScopedId datedServiceJourneyId) {
        return this.transitService.getTripOnServiceDateById(datedServiceJourneyId);
    }

    public FeedScopedId resolveDatedServiceJourneyId(EstimatedVehicleJourney estimatedVehicleJourney) {
        DatedVehicleJourneyRef datedVehicleJourneyRef = estimatedVehicleJourney.getDatedVehicleJourneyRef();
        if (datedVehicleJourneyRef != null) {
            return this.resolveId(datedVehicleJourneyRef.getValue());
        }
        if (estimatedVehicleJourney.getEstimatedVehicleJourneyCode() != null) {
            return this.resolveId(estimatedVehicleJourney.getEstimatedVehicleJourneyCode());
        }
        return null;
    }

    public LocalDate resolveServiceDate(FramedVehicleJourneyRefStructure vehicleJourneyRefStructure) {
        DataFrameRefStructure dataFrame;
        if (vehicleJourneyRefStructure.getDataFrameRef() != null && (dataFrame = vehicleJourneyRefStructure.getDataFrameRef()) != null) {
            try {
                return LocalDate.parse(dataFrame.getValue());
            }
            catch (DateTimeParseException ignored) {
                LOG.warn("Invalid dataFrame format: {}", (Object)dataFrame.getValue());
            }
        }
        return null;
    }

    public LocalDate resolveServiceDate(ZonedDateTime originAimedDepartureTime) {
        if (originAimedDepartureTime == null) {
            return null;
        }
        return originAimedDepartureTime.toLocalDate();
    }

    public Trip resolveTrip(FramedVehicleJourneyRefStructure journey) {
        if (journey != null) {
            return this.resolveTrip(journey.getDatedVehicleJourneyRef());
        }
        return null;
    }

    public Trip resolveTrip(String serviceJourneyId) {
        return this.transitService.getTripForId(this.resolveId(serviceJourneyId));
    }

    public RegularStop resolveQuay(String quayRef) {
        return this.transitService.getRegularStop(this.resolveId(quayRef));
    }

    public Route resolveRoute(String lineRef) {
        return this.transitService.getRouteForId(this.resolveId(lineRef));
    }

    public Operator resolveOperator(String operatorRef) {
        return this.transitService.getOperatorForId(this.resolveId(operatorRef));
    }

    public LocalDate resolveServiceDate(EstimatedVehicleJourney vehicleJourney) {
        TripOnServiceDate datedServiceJourney;
        FeedScopedId datedServiceJourneyId;
        DataFrameRefStructure dataFrame;
        if (vehicleJourney.getFramedVehicleJourneyRef() != null && (dataFrame = vehicleJourney.getFramedVehicleJourneyRef().getDataFrameRef()) != null) {
            try {
                return LocalDate.parse(dataFrame.getValue());
            }
            catch (DateTimeParseException ignored) {
                LOG.warn("Invalid dataFrame format: {}", (Object)dataFrame.getValue());
            }
        }
        if ((datedServiceJourneyId = this.resolveDatedServiceJourneyId(vehicleJourney)) != null && (datedServiceJourney = this.resolveTripOnServiceDate(datedServiceJourneyId)) != null) {
            return datedServiceJourney.getServiceDate();
        }
        ZonedDateTime date = CallWrapper.of(vehicleJourney).get(0).getAimedDepartureTime();
        if (date == null) {
            return null;
        }
        int daysOffset = this.calculateDayOffset(vehicleJourney);
        return date.toLocalDate().minusDays(daysOffset);
    }

    TripOnServiceDateBuilder createTripOnServiceDateBuilder(EstimatedVehicleJourney estimatedVehicleJourney) {
        TripOnServiceDate replacedDatedServiceJourney;
        FeedScopedId datedServiceJourneyId = this.resolveDatedServiceJourneyId(estimatedVehicleJourney);
        if (datedServiceJourneyId == null && estimatedVehicleJourney.getFramedVehicleJourneyRef() != null) {
            TripOnServiceDate tripOnDate = this.resolveTripOnServiceDate(estimatedVehicleJourney.getFramedVehicleJourneyRef());
            if (tripOnDate == null) {
                return null;
            }
            datedServiceJourneyId = tripOnDate.getId();
        }
        if (datedServiceJourneyId == null) {
            return null;
        }
        ArrayList<TripOnServiceDate> listOfReplacedVehicleJourneys = new ArrayList<TripOnServiceDate>();
        VehicleJourneyRef vehicleJourneyRef = estimatedVehicleJourney.getVehicleJourneyRef();
        if (vehicleJourneyRef != null && (replacedDatedServiceJourney = this.resolveTripOnServiceDate(vehicleJourneyRef.getValue())) != null) {
            listOfReplacedVehicleJourneys.add(replacedDatedServiceJourney);
        }
        estimatedVehicleJourney.getAdditionalVehicleJourneyReves().stream().map(this::resolveTripOnServiceDate).filter(Objects::nonNull).forEach(listOfReplacedVehicleJourneys::add);
        return TripOnServiceDate.of(datedServiceJourneyId).withReplacementFor(listOfReplacedVehicleJourneys);
    }

    private int calculateDayOffset(EstimatedVehicleJourney vehicleJourney) {
        Trip trip = this.resolveTrip(vehicleJourney);
        if (trip == null) {
            return 0;
        }
        TripPattern pattern = this.transitService.getPatternForTrip(trip);
        if (pattern == null) {
            return 0;
        }
        TripTimes tripTimes = pattern.getScheduledTimetable().getTripTimes(trip);
        if (tripTimes == null) {
            return 0;
        }
        int departureTime = tripTimes.getDepartureTime(0);
        int days = (int)Duration.ofSeconds(departureTime).toDays();
        if (departureTime < 0) {
            return days - 1;
        }
        return days;
    }
}

