/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import uk.org.siri.siri20.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri20.CallStatusEnumeration;
import uk.org.siri.siri20.DepartureBoardingActivityEnumeration;
import uk.org.siri.siri20.EstimatedCall;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.OccupancyEnumeration;
import uk.org.siri.siri20.RecordedCall;

public interface CallWrapper {
    public static CallWrapper of(EstimatedCall estimatedCall) {
        return new EstimatedCallWrapper(estimatedCall);
    }

    public static CallWrapper of(RecordedCall recordedCall) {
        return new RecordedCallWrapper(recordedCall);
    }

    public static List<CallWrapper> of(EstimatedVehicleJourney estimatedVehicleJourney) {
        ArrayList<CallWrapper> result = new ArrayList<CallWrapper>();
        if (estimatedVehicleJourney.getRecordedCalls() != null) {
            for (RecordedCall recordedCall : estimatedVehicleJourney.getRecordedCalls().getRecordedCalls()) {
                result.add(new RecordedCallWrapper(recordedCall));
            }
        }
        if (estimatedVehicleJourney.getEstimatedCalls() != null) {
            for (EstimatedCall estimatedCall : estimatedVehicleJourney.getEstimatedCalls().getEstimatedCalls()) {
                result.add(new EstimatedCallWrapper(estimatedCall));
            }
        }
        return List.copyOf(result);
    }

    public String getStopPointRef();

    public Boolean isCancellation();

    public Boolean isPredictionInaccurate();

    public OccupancyEnumeration getOccupancy();

    public List<NaturalLanguageStringStructure> getDestinationDisplaies();

    public ZonedDateTime getAimedArrivalTime();

    public ZonedDateTime getExpectedArrivalTime();

    public ZonedDateTime getActualArrivalTime();

    public CallStatusEnumeration getArrivalStatus();

    public ArrivalBoardingActivityEnumeration getArrivalBoardingActivity();

    public ZonedDateTime getAimedDepartureTime();

    public ZonedDateTime getExpectedDepartureTime();

    public ZonedDateTime getActualDepartureTime();

    public CallStatusEnumeration getDepartureStatus();

    public DepartureBoardingActivityEnumeration getDepartureBoardingActivity();

    public static final class EstimatedCallWrapper
    implements CallWrapper {
        private final EstimatedCall call;

        private EstimatedCallWrapper(EstimatedCall estimatedCall) {
            this.call = estimatedCall;
        }

        @Override
        public String getStopPointRef() {
            return this.call.getStopPointRef() != null ? this.call.getStopPointRef().getValue() : null;
        }

        @Override
        public Boolean isCancellation() {
            return this.call.isCancellation();
        }

        @Override
        public Boolean isPredictionInaccurate() {
            return this.call.isPredictionInaccurate();
        }

        @Override
        public OccupancyEnumeration getOccupancy() {
            return this.call.getOccupancy();
        }

        @Override
        public List<NaturalLanguageStringStructure> getDestinationDisplaies() {
            return this.call.getDestinationDisplaies();
        }

        @Override
        public ZonedDateTime getAimedArrivalTime() {
            return this.call.getAimedArrivalTime();
        }

        @Override
        public ZonedDateTime getExpectedArrivalTime() {
            return this.call.getExpectedArrivalTime();
        }

        @Override
        public ZonedDateTime getActualArrivalTime() {
            return null;
        }

        @Override
        public CallStatusEnumeration getArrivalStatus() {
            return this.call.getArrivalStatus();
        }

        @Override
        public ArrivalBoardingActivityEnumeration getArrivalBoardingActivity() {
            return this.call.getArrivalBoardingActivity();
        }

        @Override
        public ZonedDateTime getAimedDepartureTime() {
            return this.call.getAimedDepartureTime();
        }

        @Override
        public ZonedDateTime getExpectedDepartureTime() {
            return this.call.getExpectedDepartureTime();
        }

        @Override
        public ZonedDateTime getActualDepartureTime() {
            return null;
        }

        @Override
        public CallStatusEnumeration getDepartureStatus() {
            return this.call.getDepartureStatus();
        }

        @Override
        public DepartureBoardingActivityEnumeration getDepartureBoardingActivity() {
            return this.call.getDepartureBoardingActivity();
        }

        public int hashCode() {
            return this.call.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EstimatedCallWrapper)) {
                return false;
            }
            EstimatedCallWrapper estimatedCallWrapper = (EstimatedCallWrapper)obj;
            return this.call.equals(estimatedCallWrapper.call);
        }
    }

    public static final class RecordedCallWrapper
    implements CallWrapper {
        private final RecordedCall call;

        private RecordedCallWrapper(RecordedCall estimatedCall) {
            this.call = estimatedCall;
        }

        @Override
        public String getStopPointRef() {
            return this.call.getStopPointRef() != null ? this.call.getStopPointRef().getValue() : null;
        }

        @Override
        public Boolean isCancellation() {
            return this.call.isCancellation();
        }

        @Override
        public Boolean isPredictionInaccurate() {
            return this.call.isPredictionInaccurate();
        }

        @Override
        public OccupancyEnumeration getOccupancy() {
            return this.call.getOccupancy();
        }

        @Override
        public List<NaturalLanguageStringStructure> getDestinationDisplaies() {
            return List.of();
        }

        @Override
        public ZonedDateTime getAimedArrivalTime() {
            return this.call.getAimedArrivalTime();
        }

        @Override
        public ZonedDateTime getExpectedArrivalTime() {
            return this.call.getExpectedArrivalTime();
        }

        @Override
        public ZonedDateTime getActualArrivalTime() {
            return this.call.getActualArrivalTime();
        }

        @Override
        public CallStatusEnumeration getArrivalStatus() {
            return null;
        }

        @Override
        public ArrivalBoardingActivityEnumeration getArrivalBoardingActivity() {
            return null;
        }

        @Override
        public ZonedDateTime getAimedDepartureTime() {
            return this.call.getAimedDepartureTime();
        }

        @Override
        public ZonedDateTime getExpectedDepartureTime() {
            return this.call.getExpectedDepartureTime();
        }

        @Override
        public ZonedDateTime getActualDepartureTime() {
            return this.call.getActualDepartureTime();
        }

        @Override
        public CallStatusEnumeration getDepartureStatus() {
            return null;
        }

        @Override
        public DepartureBoardingActivityEnumeration getDepartureBoardingActivity() {
            return null;
        }

        public int hashCode() {
            return this.call.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RecordedCallWrapper)) {
                return false;
            }
            RecordedCallWrapper recordedCallWrapper = (RecordedCallWrapper)obj;
            return this.call.equals(recordedCallWrapper.call);
        }
    }
}

