/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.opentripplanner.ext.siri.CallWrapper;
import org.opentripplanner.ext.siri.EntityResolver;
import org.opentripplanner.ext.siri.TimetableHelper;
import org.opentripplanner.ext.siri.TripUpdate;
import org.opentripplanner.ext.siri.mapper.PickDropMapper;
import org.opentripplanner.ext.siri.mapper.SiriTransportModeMapper;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.framework.time.ServiceDateUtils;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.UpdateError;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.framework.Result;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.RouteBuilder;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.organization.Operator;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripBuilder;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitModel;
import org.rutebanken.netex.model.BusSubmodeEnumeration;
import org.rutebanken.netex.model.RailSubmodeEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.OccupancyEnumeration;

class AddedTripBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AddedTripBuilder.class);
    private final TransitModel transitModel;
    private final EntityResolver entityResolver;
    private final ZoneId timeZone;
    private final Function<Trip, FeedScopedId> getTripPatternId;
    private final FeedScopedId tripId;
    private final Operator operator;
    private final String lineRef;
    private final Route replacedRoute;
    private final LocalDate serviceDate;
    private final TransitMode transitMode;
    private final String transitSubMode;
    private final List<CallWrapper> calls;
    private final boolean isJourneyPredictionInaccurate;
    private final OccupancyEnumeration occupancy;
    private final boolean cancellation;
    private final String shortName;
    private final String headsign;

    AddedTripBuilder(EstimatedVehicleJourney estimatedVehicleJourney, TransitModel transitModel, EntityResolver entityResolver, Function<Trip, FeedScopedId> getTripPatternId) {
        String newServiceJourneyRef = estimatedVehicleJourney.getEstimatedVehicleJourneyCode();
        Objects.requireNonNull(newServiceJourneyRef, "EstimatedVehicleJourneyCode is required");
        this.tripId = entityResolver.resolveId(newServiceJourneyRef);
        Objects.requireNonNull(estimatedVehicleJourney.getOperatorRef(), "OperatorRef is required");
        String operatorRef = estimatedVehicleJourney.getOperatorRef().getValue();
        this.operator = entityResolver.resolveOperator(operatorRef);
        Objects.requireNonNull(estimatedVehicleJourney.getLineRef(), "LineRef is required");
        this.lineRef = estimatedVehicleJourney.getLineRef().getValue();
        String externalLineRef = estimatedVehicleJourney.getExternalLineRef() != null ? estimatedVehicleJourney.getExternalLineRef().getValue() : this.lineRef;
        this.replacedRoute = entityResolver.resolveRoute(externalLineRef);
        this.serviceDate = entityResolver.resolveServiceDate(estimatedVehicleJourney);
        this.shortName = AddedTripBuilder.getFirstNameFromList(estimatedVehicleJourney.getPublishedLineNames());
        List vehicleModes = estimatedVehicleJourney.getVehicleModes();
        this.transitMode = SiriTransportModeMapper.mapTransitMainMode(vehicleModes);
        this.transitSubMode = AddedTripBuilder.resolveTransitSubMode(this.transitMode, this.replacedRoute);
        this.isJourneyPredictionInaccurate = Boolean.TRUE.equals(estimatedVehicleJourney.isPredictionInaccurate());
        this.occupancy = estimatedVehicleJourney.getOccupancy();
        this.cancellation = Boolean.TRUE.equals(estimatedVehicleJourney.isCancellation());
        this.headsign = AddedTripBuilder.getFirstNameFromList(estimatedVehicleJourney.getDestinationNames());
        this.calls = CallWrapper.of(estimatedVehicleJourney);
        this.transitModel = transitModel;
        this.entityResolver = entityResolver;
        this.getTripPatternId = getTripPatternId;
        this.timeZone = transitModel.getTimeZone();
    }

    AddedTripBuilder(TransitModel transitModel, EntityResolver entityResolver, Function<Trip, FeedScopedId> getTripPatternId, FeedScopedId tripId, Operator operator, String lineRef, Route replacedRoute, LocalDate serviceDate, TransitMode transitMode, String transitSubMode, List<CallWrapper> calls, boolean isJourneyPredictionInaccurate, OccupancyEnumeration occupancy, boolean cancellation, String shortName, String headsign) {
        this.transitModel = transitModel;
        this.entityResolver = entityResolver;
        this.timeZone = transitModel.getTimeZone();
        this.getTripPatternId = getTripPatternId;
        this.tripId = tripId;
        this.operator = operator;
        this.lineRef = lineRef;
        this.replacedRoute = replacedRoute;
        this.serviceDate = serviceDate;
        this.transitMode = transitMode;
        this.transitSubMode = transitSubMode;
        this.calls = calls;
        this.isJourneyPredictionInaccurate = isJourneyPredictionInaccurate;
        this.occupancy = occupancy;
        this.cancellation = cancellation;
        this.shortName = shortName;
        this.headsign = headsign;
    }

    Result<TripUpdate, UpdateError> build() {
        if (this.serviceDate == null) {
            return UpdateError.result(this.tripId, UpdateError.UpdateErrorType.NO_START_DATE);
        }
        FeedScopedId calServiceId = this.transitModel.getOrCreateServiceIdForDate(this.serviceDate);
        if (calServiceId == null) {
            return UpdateError.result(this.tripId, UpdateError.UpdateErrorType.NO_START_DATE);
        }
        Route route = this.entityResolver.resolveRoute(this.lineRef);
        if (route == null) {
            route = this.createRoute();
            LOG.info("Adding route {} to transitModel.", (Object)route);
            this.transitModel.getTransitModelIndex().addRoutes(route);
        }
        Trip trip = this.createTrip(route, calServiceId);
        ZonedDateTime departureDate = this.serviceDate.atStartOfDay(this.timeZone);
        ArrayList<StopTime> aimedStopTimes = new ArrayList<StopTime>();
        for (int stopSequence = 0; stopSequence < this.calls.size(); ++stopSequence) {
            StopTime stopTime = this.createStopTime(trip, departureDate, stopSequence, this.calls.get(stopSequence), stopSequence == 0, stopSequence == this.calls.size() - 1);
            aimedStopTimes.add(stopTime);
        }
        StopPattern stopPattern = new StopPattern(aimedStopTimes);
        TripPattern pattern = (TripPattern)TripPattern.of(this.getTripPatternId.apply(trip)).withRoute(trip.getRoute()).withMode(trip.getMode()).withNetexSubmode(trip.getNetexSubMode()).withStopPattern(stopPattern).build();
        TripTimes tripTimes = new TripTimes(trip, aimedStopTimes, this.transitModel.getDeduplicator());
        tripTimes.setServiceCode(this.transitModel.getServiceCodes().get(trip.getServiceId()));
        pattern.add(tripTimes);
        TripTimes updatedTripTimes = new TripTimes(tripTimes);
        for (int stopSequence = 0; stopSequence < this.calls.size(); ++stopSequence) {
            TimetableHelper.applyUpdates(departureDate, updatedTripTimes, stopSequence, stopSequence == this.calls.size() - 1, this.isJourneyPredictionInaccurate, this.calls.get(stopSequence), this.occupancy);
        }
        if (this.cancellation || stopPattern.isAllStopsNonRoutable()) {
            updatedTripTimes.cancelTrip();
        } else {
            updatedTripTimes.setRealTimeState(RealTimeState.ADDED);
        }
        Result<?, UpdateError> validityResult = updatedTripTimes.validateNonIncreasingTimes();
        if (validityResult.isFailure()) {
            return validityResult.toFailureResult();
        }
        this.transitModel.getTransitModelIndex().getTripForId().put(this.tripId, trip);
        this.transitModel.getTransitModelIndex().getPatternForTrip().put(trip, pattern);
        this.transitModel.getTransitModelIndex().getPatternsForRoute().put((Object)route, (Object)pattern);
        return Result.success(new TripUpdate(stopPattern, updatedTripTimes, this.serviceDate));
    }

    private Route createRoute() {
        RouteBuilder routeBuilder = Route.of(this.entityResolver.resolveId(this.lineRef));
        routeBuilder.withShortName(this.shortName);
        routeBuilder.withMode(this.transitMode);
        routeBuilder.withNetexSubmode(this.transitSubMode);
        routeBuilder.withOperator(this.operator);
        Agency agency = this.transitModel.getTransitModelIndex().getAllRoutes().stream().filter(r -> r != null && r.getOperator() != null && r.getOperator().equals(this.operator)).findFirst().map(Route::getAgency).orElseGet(() -> this.replacedRoute != null ? this.replacedRoute.getAgency() : null);
        routeBuilder.withAgency(agency);
        return (Route)routeBuilder.build();
    }

    private Trip createTrip(Route route, FeedScopedId calServiceId) {
        TripBuilder tripBuilder = Trip.of(this.tripId);
        tripBuilder.withRoute(route);
        tripBuilder.withMode(this.transitMode);
        tripBuilder.withNetexSubmode(this.transitSubMode);
        tripBuilder.withServiceId(calServiceId);
        tripBuilder.withHeadsign(NonLocalizedString.ofNullable(this.headsign));
        tripBuilder.withOperator(this.operator);
        return (Trip)tripBuilder.build();
    }

    private StopTime createStopTime(Trip trip, ZonedDateTime departureDate, int stopSequence, CallWrapper call, boolean isFirstStop, boolean isLastStop) {
        StopTime stopTime = new StopTime();
        stopTime.setStopSequence(stopSequence);
        stopTime.setTrip(trip);
        stopTime.setStop(this.entityResolver.resolveQuay(call.getStopPointRef()));
        ZonedDateTime aimedArrivalTime = call.getAimedArrivalTime() != null ? call.getAimedArrivalTime() : call.getAimedDepartureTime();
        int aimedArrivalTimeSeconds = ServiceDateUtils.secondsSinceStartOfService(departureDate, aimedArrivalTime, this.timeZone);
        ZonedDateTime aimedDepartureTime = call.getAimedDepartureTime() != null ? call.getAimedDepartureTime() : call.getAimedArrivalTime();
        int aimedDepartureTimeSeconds = ServiceDateUtils.secondsSinceStartOfService(departureDate, aimedDepartureTime, this.timeZone);
        stopTime.setArrivalTime(isFirstStop ? aimedDepartureTimeSeconds : aimedArrivalTimeSeconds);
        stopTime.setDepartureTime(isLastStop ? aimedArrivalTimeSeconds : aimedDepartureTimeSeconds);
        String destinationDisplay = AddedTripBuilder.getFirstNameFromList(call.getDestinationDisplaies());
        if (!destinationDisplay.isEmpty()) {
            stopTime.setStopHeadsign(new NonLocalizedString(destinationDisplay));
        } else if (trip.getHeadsign() != null) {
            stopTime.setStopHeadsign(trip.getHeadsign());
        } else {
            stopTime.setStopHeadsign(new NonLocalizedString(""));
        }
        PickDropMapper.mapPickUpType(call, stopTime.getPickupType()).ifPresent(stopTime::setPickupType);
        PickDropMapper.mapDropOffType(call, stopTime.getDropOffType()).ifPresent(stopTime::setDropOffType);
        return stopTime;
    }

    private static String getFirstNameFromList(List<NaturalLanguageStringStructure> names) {
        if (names == null) {
            return "";
        }
        return names.stream().findFirst().map(NaturalLanguageStringStructure::getValue).orElse("");
    }

    static String resolveTransitSubMode(TransitMode transitMode, Route replacedRoute) {
        if (replacedRoute == null) {
            return null;
        }
        TransitMode replacedRouteMode = replacedRoute.getMode();
        if (replacedRouteMode != TransitMode.RAIL) {
            return null;
        }
        return switch (transitMode) {
            case TransitMode.RAIL -> RailSubmodeEnumeration.REPLACEMENT_RAIL_SERVICE.value();
            case TransitMode.BUS -> BusSubmodeEnumeration.RAIL_REPLACEMENT_BUS.value();
            default -> null;
        };
    }
}

