/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.ridehailing;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.opentripplanner.ext.ridehailing.RideHailingService;
import org.opentripplanner.ext.ridehailing.model.RideEstimate;
import org.opentripplanner.ext.ridehailing.model.RideHailingLeg;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RideHailingFilter
implements ItineraryListFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RideHailingFilter.class);
    public static final String NO_RIDE_HAILING_AVAILABLE = "no-ride-hailing-available";
    private final List<RideHailingService> rideHailingServices;

    public RideHailingFilter(List<RideHailingService> rideHailingServices) {
        this.rideHailingServices = rideHailingServices;
    }

    @Override
    public List<Itinerary> filter(List<Itinerary> itineraries) {
        return this.rideHailingServices.parallelStream().flatMap(service -> itineraries.parallelStream().map(i -> this.addRideHailingInformation((Itinerary)i, (RideHailingService)service))).toList();
    }

    private static void flagForDeletion(Itinerary i) {
        i.flagForDeletion(new SystemNotice(NO_RIDE_HAILING_AVAILABLE, "This itinerary is marked as deleted by the no-ride-hailing-available filter."));
    }

    private Itinerary addRideHailingInformation(Itinerary i, RideHailingService service) {
        if (!i.isFlaggedForDeletion()) {
            List<Leg> legs = i.getLegs().parallelStream().map(leg -> this.decorateLegWithRideEstimate(i, (Leg)leg, service)).toList();
            i.setLegs(legs);
        }
        return i;
    }

    private Leg decorateLegWithRideEstimate(Itinerary i, Leg leg, RideHailingService service) {
        try {
            StreetLeg sl;
            if (leg instanceof StreetLeg && (sl = (StreetLeg)leg).getMode().isDriving()) {
                List<RideEstimate> estimates = service.rideEstimates(leg.getFrom().coordinate, leg.getTo().coordinate);
                if (estimates.isEmpty()) {
                    RideHailingFilter.flagForDeletion(i);
                    return leg;
                }
                return new RideHailingLeg(sl, service.provider(), estimates.get(0));
            }
            return leg;
        }
        catch (ExecutionException e) {
            LOG.error("Could not get ride hailing estimate for {}", (Object)service.provider(), (Object)e);
            RideHailingFilter.flagForDeletion(i);
            return leg;
        }
    }
}

