/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.model;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class CachedValue<T> {
    private final Duration cacheInterval;
    private T value = null;
    private Instant timeout;

    public CachedValue(@Nonnull Duration cacheInterval) {
        this.cacheInterval = cacheInterval;
        this.timeout = this.calculateTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(@Nonnull Supplier<T> supplier) {
        CachedValue cachedValue = this;
        synchronized (cachedValue) {
            if (this.hasExpired()) {
                this.value = supplier.get();
                this.timeout = this.calculateTimeout();
            }
        }
        return this.value;
    }

    private Instant calculateTimeout() {
        return Instant.now().plus(this.cacheInterval);
    }

    private boolean hasExpired() {
        return this.value == null || this.timeout.isBefore(Instant.now());
    }
}

