/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.mapping;

import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.routing.alertpatch.TimePeriod;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.alertpatch.TransitAlertBuilder;
import org.opentripplanner.street.model.note.StreetNote;
import org.opentripplanner.transit.model.framework.FeedScopedId;

public class StreetNoteMapper {
    public static TransitAlert mapStreetNoteToAlert(StreetNote note) {
        TransitAlertBuilder alert = TransitAlert.of(new FeedScopedId("StreetNote", Integer.toString(note.hashCode())));
        alert.withHeaderText(note.note);
        alert.withDescriptionText(note.descriptionText);
        alert.withUrl(NonLocalizedString.ofNullable(note.url));
        if (note.effectiveStartDate != null && note.effectiveEndDate != null) {
            alert.addTimePeriod(new TimePeriod(note.effectiveStartDate.getTime() / 1000L, note.effectiveEndDate.getTime() / 1000L));
        }
        return (TransitAlert)alert.build();
    }
}

