/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.ext.legacygraphqlapi.mapping.StreetNoteMapper;
import org.opentripplanner.model.plan.AbsoluteDirection;
import org.opentripplanner.model.plan.ElevationProfile;
import org.opentripplanner.model.plan.RelativeDirection;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.alertpatch.TransitAlert;

public class LegacyGraphQLstepImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLStep {
    @Override
    public DataFetcher<LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection> absoluteDirection() {
        return environment -> switch (this.getSource(environment).getAbsoluteDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case AbsoluteDirection.NORTH -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.NORTH;
            case AbsoluteDirection.NORTHEAST -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.NORTHEAST;
            case AbsoluteDirection.EAST -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.EAST;
            case AbsoluteDirection.SOUTHEAST -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.SOUTHEAST;
            case AbsoluteDirection.SOUTH -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.SOUTH;
            case AbsoluteDirection.SOUTHWEST -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.SOUTHWEST;
            case AbsoluteDirection.WEST -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.WEST;
            case AbsoluteDirection.NORTHWEST -> LegacyGraphQLTypes.LegacyGraphQLAbsoluteDirection.NORTHWEST;
        };
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> this.getSource(environment).getStreetNotes().stream().map(StreetNoteMapper::mapStreetNoteToAlert).toList();
    }

    @Override
    public DataFetcher<Boolean> area() {
        return environment -> this.getSource(environment).getArea();
    }

    @Override
    public DataFetcher<Boolean> bogusName() {
        return environment -> this.getSource(environment).getBogusName();
    }

    @Override
    public DataFetcher<Double> distance() {
        return environment -> this.getSource(environment).getDistance();
    }

    @Override
    public DataFetcher<Iterable<ElevationProfile.Step>> elevationProfile() {
        return environment -> this.getSource(environment).getElevationProfile().steps();
    }

    @Override
    public DataFetcher<String> exit() {
        return environment -> this.getSource(environment).getExit();
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getStartLocation().latitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getStartLocation().longitude();
    }

    @Override
    public DataFetcher<LegacyGraphQLTypes.LegacyGraphQLRelativeDirection> relativeDirection() {
        return environment -> switch (this.getSource(environment).getRelativeDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case RelativeDirection.DEPART -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.DEPART;
            case RelativeDirection.HARD_LEFT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.HARD_LEFT;
            case RelativeDirection.LEFT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.LEFT;
            case RelativeDirection.SLIGHTLY_LEFT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.SLIGHTLY_LEFT;
            case RelativeDirection.CONTINUE -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.CONTINUE;
            case RelativeDirection.SLIGHTLY_RIGHT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.SLIGHTLY_RIGHT;
            case RelativeDirection.RIGHT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.RIGHT;
            case RelativeDirection.HARD_RIGHT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.HARD_RIGHT;
            case RelativeDirection.CIRCLE_CLOCKWISE -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.CIRCLE_CLOCKWISE;
            case RelativeDirection.CIRCLE_COUNTERCLOCKWISE -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.CIRCLE_COUNTERCLOCKWISE;
            case RelativeDirection.ELEVATOR -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.ELEVATOR;
            case RelativeDirection.UTURN_LEFT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.UTURN_LEFT;
            case RelativeDirection.UTURN_RIGHT -> LegacyGraphQLTypes.LegacyGraphQLRelativeDirection.UTURN_RIGHT;
        };
    }

    @Override
    public DataFetcher<Boolean> stayOn() {
        return environment -> this.getSource(environment).getStayOn();
    }

    @Override
    public DataFetcher<String> streetName() {
        return environment -> this.getSource(environment).getStreetName().toString(environment.getLocale());
    }

    @Override
    public DataFetcher<Boolean> walkingBike() {
        return environment -> this.getSource(environment).isWalkingBike();
    }

    private WalkStep getSource(DataFetchingEnvironment environment) {
        return (WalkStep)environment.getSource();
    }
}

