/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalPlace;
import org.opentripplanner.service.vehiclerental.model.VehicleRentalStationUris;

public class LegacyGraphQLVehicleRentalStationImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLVehicleRentalStation {
    @Override
    public DataFetcher<Boolean> allowDropoff() {
        return environment -> this.getSource(environment).isAllowDropoff();
    }

    @Override
    public DataFetcher<Boolean> allowDropoffNow() {
        return environment -> this.getSource(environment).allowDropoffNow();
    }

    @Override
    public DataFetcher<Boolean> allowOverloading() {
        return environment -> this.getSource(environment).overloadingAllowed();
    }

    @Override
    public DataFetcher<Boolean> allowPickup() {
        return environment -> this.getSource(environment).isAllowPickup();
    }

    @Override
    public DataFetcher<Boolean> allowPickupNow() {
        return environment -> this.getSource(environment).allowPickupNow();
    }

    @Override
    public DataFetcher<Integer> capacity() {
        return environment -> this.getSource(environment).getCapacity();
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("VehicleRentalStation", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getLatitude();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getLongitude();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).getName().toString(environment.getLocale());
    }

    @Override
    public DataFetcher<String> network() {
        return environment -> this.getSource(environment).getNetwork();
    }

    @Override
    public DataFetcher<Boolean> operative() {
        return environment -> this.getSource(environment).isAllowPickup() && this.getSource(environment).isAllowDropoff();
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).isRealTimeData();
    }

    @Override
    public DataFetcher<VehicleRentalStationUris> rentalUris() {
        return environment -> this.getSource(environment).getRentalUris();
    }

    @Override
    public DataFetcher<Integer> spacesAvailable() {
        return environment -> this.getSource(environment).getSpacesAvailable();
    }

    @Override
    public DataFetcher<String> stationId() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<Integer> vehiclesAvailable() {
        return environment -> this.getSource(environment).getVehiclesAvailable();
    }

    private VehicleRentalPlace getSource(DataFetchingEnvironment environment) {
        return (VehicleRentalPlace)environment.getSource();
    }
}

