/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.opentripplanner.ext.interactivelauncher.Model;
import org.opentripplanner.ext.interactivelauncher.views.DataSourcesView;
import org.opentripplanner.ext.interactivelauncher.views.OptionsView;
import org.opentripplanner.ext.interactivelauncher.views.SearchDirectoryView;
import org.opentripplanner.ext.interactivelauncher.views.StartOtpButtonView;
import org.opentripplanner.ext.interactivelauncher.views.StatusBar;
import org.opentripplanner.ext.interactivelauncher.views.ViewUtils;

public class MainView {
    private static final int M_IN = 10;
    private static final int M_OUT = 20;
    private static final GridBagConstraints CONFIG_SOURCE_DIR_PANEL_CONSTRAINTS = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 1, new Insets(20, 20, 10, 10), 0, 0);
    private static final GridBagConstraints CONFIG_DIRS_PANEL_CONSTRAINTS = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(20, 20, 10, 10), 0, 0);
    private static final GridBagConstraints OPTIONS_PANEL_CONSTRAINTS = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(20, 10, 10, 20), 0, 0);
    private static final GridBagConstraints START_OTP_BUTTON_PANEL_CONSTRAINTS = new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 20, 10, 20), 0, 0);
    private static final GridBagConstraints STATUS_BAR_CONSTRAINTS = new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 40, 0);
    private final JFrame mainFrame = new JFrame("Setup and Run OTP Main");
    private final DataSourcesView dataSourcesView;
    private final OptionsView optionsView;
    private final Runnable otpStarter;
    private final Model model;

    public MainView(Runnable otpStarter, Model model) throws HeadlessException {
        JPanel innerPanel = new JPanel();
        StatusBar statusBarTxt = new StatusBar();
        this.otpStarter = otpStarter;
        this.model = model;
        this.mainFrame.setContentPane(new JScrollPane(innerPanel));
        GridBagLayout layout = new GridBagLayout();
        innerPanel.setLayout(layout);
        innerPanel.setBackground(ViewUtils.BACKGROUND);
        SearchDirectoryView sourceDirectoryView = new SearchDirectoryView(model.getRootDirectory(), this::onRootDirChanged);
        this.dataSourcesView = new DataSourcesView(model);
        this.optionsView = new OptionsView(model);
        StartOtpButtonView startOtpButtonView = new StartOtpButtonView();
        innerPanel.add((Component)sourceDirectoryView.panel(), CONFIG_SOURCE_DIR_PANEL_CONSTRAINTS);
        innerPanel.add((Component)this.dataSourcesView.panel(), CONFIG_DIRS_PANEL_CONSTRAINTS);
        innerPanel.add((Component)this.optionsView.panel(), OPTIONS_PANEL_CONSTRAINTS);
        innerPanel.add((Component)startOtpButtonView.panel(), START_OTP_BUTTON_PANEL_CONSTRAINTS);
        innerPanel.add((Component)statusBarTxt, STATUS_BAR_CONSTRAINTS);
        startOtpButtonView.addActionListener(e -> this.startOtp());
        ViewUtils.debugLayout(this.dataSourcesView.panel(), this.optionsView.panel(), startOtpButtonView.panel(), statusBarTxt);
        model.subscribeCmdLineUpdates(statusBarTxt::setText);
        statusBarTxt.setText(model.toCliString());
    }

    public void onRootDirChanged(String newRootDir) {
        this.model.setRootDirectory(newRootDir);
        this.dataSourcesView.onRootDirChange();
        this.mainFrame.pack();
        this.mainFrame.repaint();
    }

    public void start() {
        this.mainFrame.setDefaultCloseOperation(3);
        this.optionsView.initState();
        this.mainFrame.pack();
        this.mainFrame.setLocationRelativeTo(null);
        this.mainFrame.setVisible(true);
    }

    private void startOtp() {
        this.mainFrame.setVisible(false);
        this.mainFrame.dispose();
        this.otpStarter.run();
    }
}

