/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class DebugLoggingSupport {
    public static List<String> getLogs() {
        ArrayList<String> result = new ArrayList<String>();
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger log : context.getLoggerList()) {
            String name = log.getName();
            if (!name.matches("(org\\.opentripplanner\\..*|[A-Z0-9_]*)") || name.equals("ROOT")) continue;
            result.add(DebugLoggingSupport.logDisplayName(name));
        }
        return result;
    }

    public static void configureDebugLogging(Map<String, Boolean> loggers) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger log : context.getLoggerList()) {
            String name = DebugLoggingSupport.logDisplayName(log.getName());
            if (!loggers.getOrDefault(name, false).booleanValue()) continue;
            log.setLevel(Level.DEBUG);
        }
    }

    private static String logDisplayName(String name) {
        return name.replace("org.opentripplanner.", "o.o.");
    }
}

