/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.geocoder;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene95.Lucene95Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.suggest.document.Completion90PostingsFormat;
import org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.lucene.search.suggest.document.ContextQuery;
import org.apache.lucene.search.suggest.document.ContextSuggestField;
import org.apache.lucene.search.suggest.document.PrefixCompletionQuery;
import org.apache.lucene.search.suggest.document.SuggestIndexSearcher;
import org.apache.lucene.search.suggest.document.TopSuggestDocs;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.site.StopLocationsGroup;
import org.opentripplanner.transit.service.TransitService;

public class LuceneIndex
implements Serializable {
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String SUGGEST = "suggest";
    private static final String NAME = "name";
    private static final String CODE = "code";
    private static final String COORDINATE = "coordinate";
    private final Graph graph;
    private final TransitService transitService;
    private final Analyzer analyzer;
    private final SuggestIndexSearcher searcher;

    public LuceneIndex(Graph graph, TransitService transitService) {
        this.graph = graph;
        this.transitService = transitService;
        this.analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(), Map.of(NAME, new SimpleAnalyzer(), SUGGEST, new CompletionAnalyzer((Analyzer)new StandardAnalyzer())));
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        try {
            try (IndexWriter directoryWriter = new IndexWriter((Directory)directory, LuceneIndex.iwcWithSuggestField(this.analyzer, Set.of(SUGGEST)));){
                transitService.listStopLocations().forEach(stopLocation -> LuceneIndex.addToIndex(directoryWriter, StopLocation.class, stopLocation.getId().toString(), stopLocation.getName(), stopLocation.getCode(), stopLocation.getCoordinate().latitude(), stopLocation.getCoordinate().longitude()));
                transitService.listStopLocationGroups().forEach(stopLocationsGroup -> LuceneIndex.addToIndex(directoryWriter, StopLocationsGroup.class, stopLocationsGroup.getId().toString(), stopLocationsGroup.getName(), null, stopLocationsGroup.getCoordinate().latitude(), stopLocationsGroup.getCoordinate().longitude()));
                graph.getVertices().stream().filter(v -> v instanceof StreetVertex).map(v -> (StreetVertex)v).forEach(streetVertex -> LuceneIndex.addToIndex(directoryWriter, StreetVertex.class, streetVertex.getLabel(), streetVertex.getIntersectionName(), streetVertex.getLabel(), streetVertex.getLat(), streetVertex.getLon()));
            }
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            this.searcher = new SuggestIndexSearcher((IndexReader)indexReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized LuceneIndex forServer(OtpServerRequestContext serverContext) {
        Graph graph = serverContext.graph();
        LuceneIndex existingIndex = graph.getLuceneIndex();
        if (existingIndex != null) {
            return existingIndex;
        }
        LuceneIndex newIndex = new LuceneIndex(graph, serverContext.transitService());
        graph.setLuceneIndex(newIndex);
        return newIndex;
    }

    public Stream<StopLocation> queryStopLocations(String query, boolean autocomplete) {
        return this.matchingDocuments(StopLocation.class, query, autocomplete).map(document -> this.transitService.getStopLocation(FeedScopedId.parseId(document.get(ID))));
    }

    public Stream<StopLocationsGroup> findStopLocationGroups(String query, boolean autocomplete) {
        return this.matchingDocuments(StopLocationsGroup.class, query, autocomplete).map(document -> this.transitService.getStopLocationsGroup(FeedScopedId.parseId(document.get(ID))));
    }

    public Stream<StreetVertex> queryStreetVertices(String query, boolean autocomplete) {
        return this.matchingDocuments(StreetVertex.class, query, autocomplete).map(document -> (StreetVertex)this.graph.getVertex(document.get(ID)));
    }

    static IndexWriterConfig iwcWithSuggestField(Analyzer analyzer, final Set<String> suggestFields) {
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        Lucene95Codec filterCodec = new Lucene95Codec(){
            final PostingsFormat postingsFormat = new Completion90PostingsFormat();

            public PostingsFormat getPostingsFormatForField(String field) {
                if (suggestFields.contains(field)) {
                    return this.postingsFormat;
                }
                return super.getPostingsFormatForField(field);
            }
        };
        iwc.setCodec((Codec)filterCodec);
        return iwc;
    }

    private static void addToIndex(IndexWriter writer, Class<?> type, String id, I18NString name, @Nullable String code, double latitude, double longitude) {
        String typeName = type.getSimpleName();
        Document document = new Document();
        document.add((IndexableField)new StoredField(ID, id));
        document.add((IndexableField)new TextField(TYPE, typeName, Field.Store.YES));
        document.add((IndexableField)new TextField(NAME, Objects.toString(name), Field.Store.YES));
        document.add((IndexableField)new ContextSuggestField(SUGGEST, Objects.toString(name), 1, new CharSequence[]{typeName}));
        document.add((IndexableField)new LatLonPoint(COORDINATE, latitude, longitude));
        if (code != null) {
            document.add((IndexableField)new TextField(CODE, code, Field.Store.YES));
            document.add((IndexableField)new ContextSuggestField(SUGGEST, code, 1, new CharSequence[]{typeName}));
        }
        try {
            writer.addDocument((Iterable)document);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Stream<Document> matchingDocuments(Class<?> type, String searchTerms, boolean autocomplete) {
        try {
            if (autocomplete) {
                PrefixCompletionQuery completionQuery = new PrefixCompletionQuery(this.analyzer, new Term(SUGGEST, this.analyzer.normalize(SUGGEST, searchTerms)));
                ContextQuery query = new ContextQuery((CompletionQuery)completionQuery);
                query.addContext((CharSequence)type.getSimpleName());
                TopSuggestDocs topDocs = this.searcher.suggest((CompletionQuery)query, 25, true);
                return Arrays.stream(topDocs.scoreDocs).map(scoreDoc -> {
                    try {
                        return this.searcher.doc(scoreDoc.doc);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            QueryParser parser = new QueryParser(CODE, this.analyzer);
            Query nameQuery = parser.createPhraseQuery(NAME, searchTerms);
            TermQuery codeQuery = new TermQuery(new Term(CODE, this.analyzer.normalize(CODE, searchTerms)));
            TermQuery typeQuery = new TermQuery(new Term(TYPE, this.analyzer.normalize(TYPE, type.getSimpleName())));
            BooleanQuery.Builder builder = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add((Query)typeQuery, BooleanClause.Occur.MUST).add((Query)codeQuery, BooleanClause.Occur.SHOULD);
            if (nameQuery != null) {
                builder.add(nameQuery, BooleanClause.Occur.SHOULD);
            }
            BooleanQuery query = builder.build();
            TopDocs topDocs = this.searcher.search((Query)query, 25);
            return Arrays.stream(topDocs.scoreDocs).map(scoreDoc -> {
                try {
                    return this.searcher.doc(scoreDoc.doc);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

