/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import jakarta.inject.Inject;
import java.util.HashSet;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.logging.ProgressTracker;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.index.StreetIndex;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.service.TransitModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexLocationsToStreetEdgesMapper
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(FlexLocationsToStreetEdgesMapper.class);
    private final Graph graph;
    private final TransitModel transitModel;

    @Inject
    public FlexLocationsToStreetEdgesMapper(Graph graph, TransitModel transitModel) {
        this.graph = graph;
        this.transitModel = transitModel;
    }

    @Override
    public void buildGraph() {
        if (!this.transitModel.getStopModel().hasAreaStops()) {
            return;
        }
        StreetIndex streetIndex = this.graph.getStreetIndexSafe(this.transitModel.getStopModel());
        ProgressTracker progress = ProgressTracker.track("Add flex locations to street vertices", 1, this.transitModel.getStopModel().listAreaStops().size());
        LOG.info(progress.startMessage());
        for (AreaStop areaStop : this.transitModel.getStopModel().listAreaStops()) {
            for (Vertex vertx : streetIndex.getVerticesForEnvelope(areaStop.getGeometry().getEnvelopeInternal())) {
                if (!(vertx instanceof StreetVertex)) continue;
                StreetVertex streetVertex = (StreetVertex)vertx;
                if (!((StreetVertex)vertx).isEligibleForCarPickupDropoff()) continue;
                Point p = GeometryUtils.getGeometryFactory().createPoint(vertx.getCoordinate());
                if (areaStop.getGeometry().disjoint((Geometry)p)) continue;
                if (streetVertex.areaStops == null) {
                    streetVertex.areaStops = new HashSet<AreaStop>();
                }
                streetVertex.areaStops.add(areaStop);
            }
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    @Override
    public void checkInputs() {
    }
}

