/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.ext.fares.impl.DefaultFareService;
import org.opentripplanner.ext.fares.impl.OrcaFaresData;
import org.opentripplanner.ext.fares.model.FareContainer;
import org.opentripplanner.ext.fares.model.FareProduct;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.fares.model.RiderCategory;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcaFareService
extends DefaultFareService {
    private static final Logger LOG = LoggerFactory.getLogger(OrcaFareService.class);
    private static final Duration MAX_TRANSFER_DISCOUNT_DURATION = Duration.ofHours(2L);
    public static final String COMM_TRANS_AGENCY_ID = "29";
    public static final String KC_METRO_AGENCY_ID = "1";
    public static final String SOUND_TRANSIT_AGENCY_ID = "40";
    public static final String EVERETT_TRANSIT_AGENCY_ID = "97";
    public static final String PIERCE_COUNTY_TRANSIT_AGENCY_ID = "3";
    public static final String SKAGIT_TRANSIT_AGENCY_ID = "e0e4541a-2714-487b-b30c-f5c6cb4a310f";
    public static final String SEATTLE_STREET_CAR_AGENCY_ID = "23";
    public static final String WASHINGTON_STATE_FERRIES_AGENCY_ID = "WSF";
    public static final String KITSAP_TRANSIT_AGENCY_ID = "kt";
    public static final int ROUTE_TYPE_FERRY = 4;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static RideType getRideType(String agencyId, Route route) {
        RideType rideType;
        RideType rideType2;
        switch (agencyId) {
            case "29": {
                try {
                    RideType rideType3;
                    int routeId = Integer.parseInt(route.getShortName());
                    if (routeId >= 500 && routeId < 600) {
                        RideType rideType4;
                        rideType2 = rideType4 = RideType.SOUND_TRANSIT_BUS;
                        return rideType2;
                    }
                    if (routeId >= 400 && routeId <= 899) {
                        RideType rideType5;
                        rideType2 = rideType5 = RideType.COMM_TRANS_COMMUTER_EXPRESS;
                        return rideType2;
                    }
                    rideType2 = rideType3 = RideType.COMM_TRANS_LOCAL_SWIFT;
                    return rideType2;
                }
                catch (NumberFormatException e) {
                    RideType rideType6;
                    LOG.warn("Unable to determine comm trans route id from {}.", (Object)route.getShortName(), (Object)e);
                    rideType2 = rideType6 = RideType.COMM_TRANS_LOCAL_SWIFT;
                    return rideType2;
                }
            }
            case "1": {
                RideType rideType7;
                try {
                    int routeId = Integer.parseInt(route.getShortName());
                    if (routeId >= 500 && routeId < 600) {
                        RideType rideType8;
                        rideType2 = rideType8 = RideType.SOUND_TRANSIT_BUS;
                        return rideType2;
                    }
                }
                catch (NumberFormatException routeId) {
                    // empty catch block
                }
                if (route.getGtfsType() == 4 && OrcaFareService.routeLongNameFallBack(route).contains("Water Taxi: West Seattle")) {
                    RideType rideType9;
                    rideType2 = rideType9 = RideType.KC_WATER_TAXI_WEST_SEATTLE;
                    return rideType2;
                }
                if (route.getGtfsType() == 4 && route.getDescription().contains("Water Taxi: Vashon Island")) {
                    RideType rideType10;
                    rideType2 = rideType10 = RideType.KC_WATER_TAXI_VASHON_ISLAND;
                    return rideType2;
                }
                rideType2 = rideType7 = RideType.KC_METRO;
                return rideType2;
            }
            case "3": {
                try {
                    RideType rideType11;
                    int routeId = Integer.parseInt(route.getShortName());
                    if (routeId >= 520 && routeId < 600) {
                        RideType rideType12;
                        rideType2 = rideType12 = RideType.SOUND_TRANSIT_BUS;
                        return rideType2;
                    }
                    rideType2 = rideType11 = RideType.PIERCE_COUNTY_TRANSIT;
                    return rideType2;
                }
                catch (NumberFormatException e) {
                    RideType rideType13;
                    LOG.warn("Unable to determine comm trans route id from {}.", (Object)route.getShortName(), (Object)e);
                    rideType2 = rideType13 = RideType.PIERCE_COUNTY_TRANSIT;
                    return rideType2;
                }
            }
            case "40": {
                RideType rideType14;
                rideType2 = rideType14 = RideType.SOUND_TRANSIT;
                return rideType2;
            }
            case "97": {
                RideType rideType15;
                rideType2 = rideType15 = RideType.EVERETT_TRANSIT;
                return rideType2;
            }
            case "e0e4541a-2714-487b-b30c-f5c6cb4a310f": {
                RideType rideType16;
                rideType2 = rideType16 = RideType.SKAGIT_TRANSIT;
                return rideType2;
            }
            case "23": {
                RideType rideType17;
                rideType2 = rideType17 = RideType.SEATTLE_STREET_CAR;
                return rideType2;
            }
            case "WSF": {
                RideType rideType18;
                rideType2 = rideType18 = RideType.WASHINGTON_STATE_FERRIES;
                return rideType2;
            }
            case "kt": {
                RideType rideType19;
                rideType2 = rideType19 = RideType.KITSAP_TRANSIT;
                return rideType2;
            }
        }
        rideType2 = rideType = RideType.UNKNOWN;
        return rideType2;
    }

    private static String routeLongNameFallBack(Route route) {
        I18NString longName = route.getLongName();
        if (longName == null) {
            return "";
        }
        return longName.toString();
    }

    public OrcaFareService(Collection<FareRuleSet> regularFareRules) {
        this.addFareRules(FareType.regular, regularFareRules);
        this.addFareRules(FareType.senior, regularFareRules);
        this.addFareRules(FareType.youth, regularFareRules);
        this.addFareRules(FareType.electronicRegular, regularFareRules);
        this.addFareRules(FareType.electronicYouth, regularFareRules);
        this.addFareRules(FareType.electronicSpecial, regularFareRules);
        this.addFareRules(FareType.electronicSenior, regularFareRules);
    }

    private static boolean checkShortName(Route route, String compareString) {
        String cleanCompareString = compareString.replaceAll("-", "").replaceAll(" ", "");
        if (route.getShortName() != null) {
            return route.getShortName().replaceAll("-", "").replaceAll(" ", "").equalsIgnoreCase(cleanCompareString);
        }
        return false;
    }

    private static String cleanStationName(String s) {
        return s.replaceAll(" ", "").replaceAll("(Northbound)", "").replaceAll("(Southbound)", "").replaceAll("Station", "").toLowerCase();
    }

    private static RideType classify(Route route, String tripId) {
        RideType rideType = OrcaFareService.getRideType(route.getAgency().getId().getId(), route);
        if (rideType == null) {
            return null;
        }
        if (rideType == RideType.KITSAP_TRANSIT && route.getId().getId().equalsIgnoreCase("Kitsap Fast Ferry") && route.getGtfsType() == 4) {
            if (tripId.contains("east")) {
                rideType = RideType.KITSAP_TRANSIT_FAST_FERRY_EASTBOUND;
            } else if (tripId.contains("west")) {
                rideType = RideType.KITSAP_TRANSIT_FAST_FERRY_WESTBOUND;
            }
        } else if (rideType == RideType.SOUND_TRANSIT && OrcaFareService.checkShortName(route, "1 Line")) {
            rideType = RideType.SOUND_TRANSIT_LINK;
        } else if (rideType == RideType.SOUND_TRANSIT && (OrcaFareService.checkShortName(route, "S Line") || OrcaFareService.checkShortName(route, "N Line"))) {
            rideType = RideType.SOUND_TRANSIT_SOUNDER;
        } else if (rideType == RideType.SOUND_TRANSIT) {
            rideType = RideType.SOUND_TRANSIT_BUS;
        }
        return rideType;
    }

    private float getLegFare(FareType fareType, RideType rideType, float defaultFare, Leg leg) {
        if (rideType == null) {
            return defaultFare;
        }
        return switch (fareType) {
            case FareType.youth, FareType.electronicYouth -> this.getYouthFare();
            case FareType.electronicSpecial -> this.getLiftFare(rideType, defaultFare, leg.getRoute());
            case FareType.electronicSenior, FareType.senior -> this.getSeniorFare(fareType, rideType, defaultFare, leg.getRoute());
            case FareType.regular, FareType.electronicRegular -> this.getRegularFare(fareType, rideType, defaultFare, leg);
            default -> defaultFare;
        };
    }

    private float getRegularFare(FareType fareType, RideType rideType, float defaultFare, Leg leg) {
        Route route = leg.getRoute();
        return switch (rideType) {
            case RideType.KC_WATER_TAXI_VASHON_ISLAND -> 5.75f;
            case RideType.KC_WATER_TAXI_WEST_SEATTLE -> 5.0f;
            case RideType.KITSAP_TRANSIT_FAST_FERRY_EASTBOUND -> 2.0f;
            case RideType.KITSAP_TRANSIT_FAST_FERRY_WESTBOUND -> 10.0f;
            case RideType.WASHINGTON_STATE_FERRIES -> this.getWashingtonStateFerriesFare(route.getLongName(), fareType, defaultFare);
            case RideType.SOUND_TRANSIT_LINK, RideType.SOUND_TRANSIT_SOUNDER -> this.getSoundTransitFare(leg, fareType, defaultFare, rideType);
            case RideType.SOUND_TRANSIT_BUS -> 3.25f;
            default -> defaultFare;
        };
    }

    private float getSoundTransitFare(Leg leg, FareType fareType, float defaultFare, RideType rideType) {
        String start = OrcaFareService.cleanStationName(leg.getFrom().name.toString());
        String end = OrcaFareService.cleanStationName(leg.getTo().name.toString());
        String lookupKey = String.format("%s-%s", start, end);
        String reverseLookupKey = String.format("%s-%s", end, start);
        Map<String, Map<FareType, Float>> fareModel = rideType == RideType.SOUND_TRANSIT_LINK ? OrcaFaresData.linkFares : OrcaFaresData.sounderFares;
        Map fare = Optional.ofNullable(fareModel.get(lookupKey)).orElseGet(() -> (Map)fareModel.get(reverseLookupKey));
        return fare != null ? ((Float)fare.get(fareType)).floatValue() : defaultFare;
    }

    private float getLiftFare(RideType rideType, float defaultFare, Route route) {
        return switch (rideType) {
            case RideType.COMM_TRANS_LOCAL_SWIFT -> 1.25f;
            case RideType.COMM_TRANS_COMMUTER_EXPRESS -> 2.0f;
            case RideType.KC_WATER_TAXI_VASHON_ISLAND -> 4.5f;
            case RideType.KC_WATER_TAXI_WEST_SEATTLE -> 3.75f;
            case RideType.KITSAP_TRANSIT -> 1.0f;
            case RideType.SOUND_TRANSIT_LINK, RideType.SOUND_TRANSIT_SOUNDER, RideType.SOUND_TRANSIT_BUS, RideType.KC_METRO, RideType.SOUND_TRANSIT, RideType.EVERETT_TRANSIT, RideType.SEATTLE_STREET_CAR -> 1.5f;
            case RideType.WASHINGTON_STATE_FERRIES -> this.getWashingtonStateFerriesFare(route.getLongName(), FareType.electronicSpecial, defaultFare);
            default -> defaultFare;
        };
    }

    private float getSeniorFare(FareType fareType, RideType rideType, float defaultFare, Route route) {
        return switch (rideType) {
            case RideType.COMM_TRANS_LOCAL_SWIFT -> 1.25f;
            case RideType.COMM_TRANS_COMMUTER_EXPRESS -> 2.0f;
            case RideType.EVERETT_TRANSIT, RideType.SKAGIT_TRANSIT -> 0.5f;
            case RideType.KITSAP_TRANSIT, RideType.SEATTLE_STREET_CAR, RideType.PIERCE_COUNTY_TRANSIT -> {
                if (fareType.equals(FareType.electronicSenior)) {
                    yield 1.0f;
                }
                yield defaultFare;
            }
            case RideType.KITSAP_TRANSIT_FAST_FERRY_EASTBOUND -> {
                if (fareType.equals(FareType.electronicSenior)) {
                    yield 1.0f;
                }
                yield 2.0f;
            }
            case RideType.KC_WATER_TAXI_VASHON_ISLAND -> 3.0f;
            case RideType.KC_WATER_TAXI_WEST_SEATTLE -> 2.5f;
            case RideType.SOUND_TRANSIT_LINK, RideType.SOUND_TRANSIT_SOUNDER, RideType.SOUND_TRANSIT_BUS, RideType.KC_METRO, RideType.SOUND_TRANSIT -> 1.0f;
            case RideType.KITSAP_TRANSIT_FAST_FERRY_WESTBOUND -> {
                if (fareType.equals(FareType.electronicSenior)) {
                    yield 5.0f;
                }
                yield 10.0f;
            }
            case RideType.WASHINGTON_STATE_FERRIES -> this.getWashingtonStateFerriesFare(route.getLongName(), fareType, defaultFare);
            default -> defaultFare;
        };
    }

    private float getYouthFare() {
        return 0.0f;
    }

    private float getWashingtonStateFerriesFare(I18NString routeLongName, FareType fareType, float defaultFare) {
        if (routeLongName == null || routeLongName.toString().isEmpty()) {
            return defaultFare;
        }
        String longName = routeLongName.toString().replaceAll(" ", "");
        Map<FareType, Float> fares = OrcaFaresData.washingtonStateFerriesFares.get(longName);
        FareType wsfFareType = fareType == FareType.electronicRegular ? FareType.regular : (fareType == FareType.electronicSenior ? FareType.senior : (fareType == FareType.electronicYouth ? FareType.youth : (fareType == FareType.electronicSpecial ? FareType.regular : fareType)));
        return fares != null && fares.get(wsfFareType) != null ? fares.get(wsfFareType).floatValue() : 0.0f;
    }

    protected float getRidePrice(Leg leg, FareType fareType, Collection<FareRuleSet> fareRules) {
        return this.calculateCost(fareType, Lists.newArrayList((Object[])new Leg[]{leg}), fareRules);
    }

    @Override
    public boolean populateFare(ItineraryFares fare, Currency currency, FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        ZonedDateTime freeTransferStartTime = null;
        float cost = 0.0f;
        float orcaFareDiscount = 0.0f;
        for (Leg leg : legs) {
            RideType rideType = OrcaFareService.classify(leg.getRoute(), leg.getTrip().getId().getId());
            boolean ridePermitsFreeTransfers = this.permitsFreeTransfers(rideType);
            if (freeTransferStartTime == null && ridePermitsFreeTransfers) {
                freeTransferStartTime = leg.getStartTime();
            }
            float singleLegPrice = this.getRidePrice(leg, fareType, fareRules);
            float legFare = this.getLegFare(fareType, rideType, singleLegPrice, leg);
            boolean inFreeTransferWindow = this.inFreeTransferWindow(freeTransferStartTime, leg.getStartTime());
            if (this.hasFreeTransfers(fareType, rideType) && inFreeTransferWindow) {
                if (legFare > orcaFareDiscount) {
                    freeTransferStartTime = leg.getStartTime();
                    OrcaFareService.addLegFareProduct(leg, fare, fareType, currency, legFare - orcaFareDiscount, orcaFareDiscount);
                    orcaFareDiscount = legFare;
                    continue;
                }
                OrcaFareService.addLegFareProduct(leg, fare, fareType, currency, 0.0f, legFare != 0.0f ? orcaFareDiscount : 0.0f);
                continue;
            }
            if (OrcaFareService.usesOrca(fareType) && !inFreeTransferWindow) {
                cost += orcaFareDiscount;
                if (ridePermitsFreeTransfers) {
                    freeTransferStartTime = leg.getStartTime();
                    orcaFareDiscount = legFare;
                } else {
                    cost += legFare;
                    freeTransferStartTime = null;
                    orcaFareDiscount = 0.0f;
                }
                OrcaFareService.addLegFareProduct(leg, fare, fareType, currency, legFare, 0.0f);
                continue;
            }
            OrcaFareService.addLegFareProduct(leg, fare, fareType, currency, legFare, 0.0f);
            cost += legFare;
        }
        if ((cost += orcaFareDiscount) < Float.POSITIVE_INFINITY) {
            fare.addFare(fareType, OrcaFareService.getMoney(currency, cost));
        }
        return cost < Float.POSITIVE_INFINITY;
    }

    private static void addLegFareProduct(Leg leg, ItineraryFares itineraryFares, FareType fareType, Currency currency, float totalFare, float transferDiscount) {
        FeedScopedId id = new FeedScopedId("orcaFares", "farePayment");
        RiderCategory riderCategory = new RiderCategory("orcaFares", OrcaFareService.getFareCategory(fareType), null);
        FareContainer fareContainer = new FareContainer("orcaFares", OrcaFareService.usesOrca(fareType) ? "electronic" : "cash");
        Duration duration = Duration.ZERO;
        Money money = new Money(currency, (int)(totalFare * 100.0f));
        FareProduct fareProduct = new FareProduct(id, "rideCost", money, duration, riderCategory, fareContainer);
        itineraryFares.addFareProduct(leg, fareProduct);
        if (transferDiscount > 0.0f) {
            Money transferDiscountMoney = new Money(currency, (int)(transferDiscount * 100.0f));
            FareProduct transferFareProduct = new FareProduct(id, "transfer", transferDiscountMoney, duration, riderCategory, fareContainer);
            itineraryFares.addFareProduct(leg, transferFareProduct);
        }
    }

    private boolean inFreeTransferWindow(ZonedDateTime freeTransferStartTime, ZonedDateTime currentLegStartTime) {
        if (freeTransferStartTime == null) {
            return false;
        }
        Duration duration = Duration.between(freeTransferStartTime, currentLegStartTime);
        return duration.compareTo(MAX_TRANSFER_DISCOUNT_DURATION) < 0;
    }

    private boolean hasFreeTransfers(FareType fareType, RideType rideType) {
        return this.permitsFreeTransfers(rideType) && OrcaFareService.usesOrca(fareType) || rideType == RideType.KC_METRO && !OrcaFareService.usesOrca(fareType);
    }

    private boolean permitsFreeTransfers(RideType rideType) {
        return switch (rideType) {
            case RideType.WASHINGTON_STATE_FERRIES, RideType.SKAGIT_TRANSIT -> false;
            default -> true;
        };
    }

    private static boolean usesOrca(FareType fareType) {
        return fareType.equals(FareType.electronicSpecial) || fareType.equals(FareType.electronicSenior) || fareType.equals(FareType.electronicRegular) || fareType.equals(FareType.electronicYouth);
    }

    private static String getFareCategory(FareType fareType) {
        String[] splitFareType = fareType.toString().split("electronic");
        if (splitFareType.length > 1) {
            return splitFareType[1].toLowerCase();
        }
        return fareType.toString();
    }

    protected static enum RideType {
        COMM_TRANS_LOCAL_SWIFT,
        COMM_TRANS_COMMUTER_EXPRESS,
        EVERETT_TRANSIT,
        KC_WATER_TAXI_VASHON_ISLAND,
        KC_WATER_TAXI_WEST_SEATTLE,
        KC_METRO,
        KITSAP_TRANSIT,
        KITSAP_TRANSIT_FAST_FERRY_EASTBOUND,
        KITSAP_TRANSIT_FAST_FERRY_WESTBOUND,
        PIERCE_COUNTY_TRANSIT,
        SKAGIT_TRANSIT,
        SEATTLE_STREET_CAR,
        SOUND_TRANSIT,
        SOUND_TRANSIT_BUS,
        SOUND_TRANSIT_SOUNDER,
        SOUND_TRANSIT_LINK,
        WASHINGTON_STATE_FERRIES,
        UNKNOWN;

    }
}

