/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.opentripplanner.ext.fares.model.Distance;
import org.opentripplanner.ext.fares.model.FareDistance;
import org.opentripplanner.ext.fares.model.FareLegRule;
import org.opentripplanner.ext.fares.model.FareProduct;
import org.opentripplanner.ext.fares.model.FareTransferRule;
import org.opentripplanner.ext.fares.model.LegProducts;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.StopLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GtfsFaresV2Service
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsFaresV2Service.class);
    private final List<FareLegRule> legRules;
    private final List<FareTransferRule> transferRules;
    private final Multimap<FeedScopedId, String> stopAreas;
    private final Set<String> networksWithRules;
    private final Set<String> fromAreasWithRules;
    private final Set<String> toAreasWithRules;

    public GtfsFaresV2Service(List<FareLegRule> legRules, List<FareTransferRule> fareTransferRules, Multimap<FeedScopedId, String> stopAreas) {
        this.legRules = legRules;
        this.transferRules = fareTransferRules;
        this.networksWithRules = GtfsFaresV2Service.findNetworksWithRules(legRules);
        this.fromAreasWithRules = GtfsFaresV2Service.findAreasWithRules(legRules, FareLegRule::fromAreaId);
        this.toAreasWithRules = GtfsFaresV2Service.findAreasWithRules(legRules, FareLegRule::toAreadId);
        this.stopAreas = stopAreas;
    }

    public ProductResult getProducts(Itinerary itinerary) {
        List<ScheduledTransitLeg> transitLegs = itinerary.getScheduledTransitLegs();
        HashSet<LegProducts> allLegProducts = new HashSet<LegProducts>();
        for (int i = 0; i < transitLegs.size(); ++i) {
            ScheduledTransitLeg leg = transitLegs.get(i);
            int nextIndex = i + 1;
            Optional<ScheduledTransitLeg> nextLeg = Optional.empty();
            if (nextIndex < transitLegs.size()) {
                nextLeg = Optional.of(transitLegs.get(nextIndex));
            }
            LegProducts lp = this.getLegProduct(leg, nextLeg);
            allLegProducts.add(lp);
        }
        Set<FareProduct> coveringItinerary = this.productsCoveringItinerary(itinerary, allLegProducts);
        return new ProductResult(coveringItinerary, allLegProducts);
    }

    private static Set<String> findAreasWithRules(List<FareLegRule> legRules, Function<FareLegRule, String> getArea) {
        return legRules.stream().map(getArea).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Set<String> findNetworksWithRules(Collection<FareLegRule> legRules) {
        return legRules.stream().map(FareLegRule::networkId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private Set<FareProduct> productsCoveringItinerary(Itinerary itinerary, Collection<LegProducts> legProducts) {
        Set distinctProductWithTransferSets = legProducts.stream().map(LegProducts::products).collect(Collectors.toSet());
        return distinctProductWithTransferSets.stream().flatMap(p -> p.stream().filter(ps -> this.coversItinerary(itinerary, (LegProducts.ProductWithTransfer)ps))).map(LegProducts.ProductWithTransfer::legRule).map(FareLegRule::fareProduct).collect(Collectors.toSet());
    }

    private boolean coversItinerary(Itinerary i, LegProducts.ProductWithTransfer pwt) {
        List<ScheduledTransitLeg> transitLegs = i.getScheduledTransitLegs();
        boolean allLegsInProductFeed = transitLegs.stream().allMatch(leg -> leg.getAgency().getId().getFeedId().equals(pwt.legRule().feedId()));
        return allLegsInProductFeed && (transitLegs.size() == 1 || pwt.product().coversDuration(i.getTransitDuration()) && this.appliesToAllLegs(pwt.legRule(), transitLegs) || this.coversItineraryWithFreeTransfers(i, pwt));
    }

    private boolean appliesToAllLegs(FareLegRule legRule, List<ScheduledTransitLeg> transitLegs) {
        return transitLegs.stream().allMatch(leg -> this.legMatchesRule((ScheduledTransitLeg)leg, legRule));
    }

    private boolean coversItineraryWithFreeTransfers(Itinerary i, LegProducts.ProductWithTransfer pwt) {
        Set feedIdsInItinerary = i.getScheduledTransitLegs().stream().map(l -> l.getAgency().getId().getFeedId()).collect(Collectors.toSet());
        return feedIdsInItinerary.size() == 1 && pwt.transferRules().stream().anyMatch(r -> r.fareProduct().amount().amount() == 0);
    }

    private boolean legMatchesRule(ScheduledTransitLeg leg, FareLegRule rule) {
        return leg.getAgency().getId().getFeedId().equals(rule.feedId()) && this.matchesNetworkId(leg, rule) && this.matchesArea(leg.getFrom().stop, rule.fromAreaId(), this.fromAreasWithRules) && this.matchesArea(leg.getTo().stop, rule.toAreadId(), this.toAreasWithRules) && this.matchesDistance(leg, rule);
    }

    private LegProducts getLegProduct(ScheduledTransitLeg leg, Optional<ScheduledTransitLeg> nextLeg) {
        Set legRules = this.legRules.stream().filter(r -> this.legMatchesRule(leg, (FareLegRule)r)).collect(Collectors.toSet());
        List<FareTransferRule> transferRulesForLeg = this.transferRules.stream().filter(t -> t.feedId().equals(leg.getAgency().getId().getFeedId())).toList();
        Set<LegProducts.ProductWithTransfer> products = legRules.stream().map(rule -> {
            List<FareTransferRule> transferRulesToNextLeg = transferRulesForLeg.stream().filter(GtfsFaresV2Service::checkForWildcards).filter(t -> t.fromLegGroup().equals(rule.legGroupId())).filter(t -> this.transferRuleMatchesNextLeg(nextLeg, (FareTransferRule)t)).toList();
            return new LegProducts.ProductWithTransfer((FareLegRule)rule, transferRulesToNextLeg);
        }).collect(Collectors.toSet());
        return new LegProducts(leg, nextLeg, products);
    }

    private static boolean checkForWildcards(FareTransferRule t) {
        if (Objects.isNull(t.fromLegGroup()) || Objects.isNull(t.toLegGroup())) {
            LOG.error("Transfer rule {} contains a wildcard leg group reference. These are not supported yet.", (Object)t);
            return false;
        }
        return true;
    }

    private boolean transferRuleMatchesNextLeg(Optional<ScheduledTransitLeg> nextLeg, FareTransferRule t) {
        return nextLeg.map(nLeg -> {
            Optional<FareLegRule> maybeFareRule = this.getFareLegRuleByGroupId(t.toLegGroup());
            return maybeFareRule.map(rule -> this.legMatchesRule((ScheduledTransitLeg)nLeg, (FareLegRule)rule)).orElse(false);
        }).orElse(false);
    }

    private Optional<FareLegRule> getFareLegRuleByGroupId(@Nonnull String groupId) {
        return this.legRules.stream().filter(lr -> groupId.equals(lr.legGroupId())).findAny();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesArea(StopLocation stop, String areaId, Set<String> areasWithRules) {
        Collection stopAreas = this.stopAreas.get((Object)stop.getId());
        if (Objects.isNull(areaId)) {
            if (stopAreas.stream().noneMatch(areasWithRules::contains)) return true;
        }
        if (!Objects.nonNull(areaId)) return false;
        if (!stopAreas.contains(areaId)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean matchesNetworkId(ScheduledTransitLeg leg, FareLegRule rule) {
        List<String> routesNetworkIds = leg.getRoute().getGroupsOfRoutes().stream().map(group -> group.getId().getId()).filter(Objects::nonNull).toList();
        if (Objects.isNull(rule.networkId())) {
            if (this.networksWithRules.stream().noneMatch(routesNetworkIds::contains)) return true;
        }
        if (!routesNetworkIds.contains(rule.networkId())) return false;
        return true;
    }

    private boolean matchesDistance(ScheduledTransitLeg leg, FareLegRule rule) {
        FareDistance distance = rule.fareDistance();
        if (distance instanceof FareDistance.Stops) {
            FareDistance.Stops ruleDistance = (FareDistance.Stops)distance;
            int numStops = leg.getIntermediateStops().size();
            return numStops >= ruleDistance.min() && ruleDistance.max() >= numStops;
        }
        FareDistance numStops = rule.fareDistance();
        if (numStops instanceof FareDistance.LinearDistance) {
            FareDistance.LinearDistance ruleDistance = (FareDistance.LinearDistance)numStops;
            Distance ruleMax = ruleDistance.max();
            Distance ruleMin = ruleDistance.min();
            double legDistance = leg.getDirectDistanceMeters();
            return legDistance > ruleMin.toMeters() && legDistance < ruleMax.toMeters();
        }
        return true;
    }

    record ProductResult(Set<FareProduct> itineraryProducts, Set<LegProducts> legProducts) {
        public Set<FareProduct> getProducts(Leg leg) {
            return this.legProducts.stream().filter(lp -> lp.leg().equals(leg)).findFirst().map(l -> l.products().stream().map(LegProducts.ProductWithTransfer::product).collect(Collectors.toSet())).orElse(Set.of());
        }
    }
}

