/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opentripplanner.ext.fares.impl.CombinedInterlinedTransitLeg;
import org.opentripplanner.ext.fares.impl.FareAndId;
import org.opentripplanner.ext.fares.impl.FareSearch;
import org.opentripplanner.ext.fares.model.FareAttribute;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.flex.FlexibleTransitLeg;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.routing.core.FareComponent;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.AbstractTransitEntity;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.FareZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFareService
implements FareService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFareService.class);
    protected Map<FareType, Collection<FareRuleSet>> fareRulesPerType = new HashMap<FareType, Collection<FareRuleSet>>();

    public void addFareRules(FareType fareType, Collection<FareRuleSet> fareRules) {
        this.fareRulesPerType.put(fareType, new ArrayList<FareRuleSet>(fareRules));
    }

    public Map<FareType, Collection<FareRuleSet>> getFareRulesPerType() {
        return this.fareRulesPerType;
    }

    @Override
    public ItineraryFares getCost(Itinerary itinerary) {
        List<Leg> fareLegs = itinerary.getLegs().stream().filter(l -> l instanceof ScheduledTransitLeg || l instanceof FlexibleTransitLeg).map(Leg.class::cast).toList();
        if ((fareLegs = this.combineInterlinedLegs(fareLegs)).isEmpty()) {
            return null;
        }
        ItineraryFares fare = ItineraryFares.empty();
        boolean hasFare = false;
        for (Map.Entry<FareType, Collection<FareRuleSet>> kv : this.fareRulesPerType.entrySet()) {
            FareType fareType = kv.getKey();
            Collection<FareRuleSet> fareRules = kv.getValue();
            Currency currency = null;
            if (fareRules.size() > 0) {
                currency = Currency.getInstance(fareRules.iterator().next().getFareAttribute().getCurrencyType());
            }
            hasFare = this.populateFare(fare, currency, fareType, fareLegs, fareRules);
        }
        return hasFare ? fare : null;
    }

    protected static Money getMoney(Currency currency, float cost) {
        int fractionDigits = 2;
        if (currency != null) {
            fractionDigits = currency.getDefaultFractionDigits();
        }
        int cents = (int)Math.round((double)cost * Math.pow(10.0, fractionDigits));
        return new Money(currency, cents);
    }

    protected float getLowestCost(FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        FareSearch r = this.performSearch(fareType, rides, fareRules);
        return r.resultTable[0][rides.size() - 1];
    }

    protected boolean populateFare(ItineraryFares fare, Currency currency, FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        FareSearch r = this.performSearch(fareType, legs, fareRules);
        ArrayList<FareComponent> details = new ArrayList<FareComponent>();
        int count = 0;
        int start = 0;
        int end = legs.size() - 1;
        while (start <= end) {
            while (start <= end && r.endOfComponent[start] < 0) {
                ++start;
            }
            if (start > end) break;
            int via = r.next[start][r.endOfComponent[start]];
            float cost = r.resultTable[start][via];
            FeedScopedId fareId = r.fareIds[start][via];
            ArrayList<FeedScopedId> routes = new ArrayList<FeedScopedId>();
            for (int i = start; i <= via; ++i) {
                routes.add(legs.get(i).getRoute().getId());
            }
            FareComponent component = new FareComponent(fareId, null, DefaultFareService.getMoney(currency, cost), routes);
            details.add(component);
            ++count;
            start = via + 1;
        }
        fare.addFare(fareType, DefaultFareService.getMoney(currency, r.resultTable[0][legs.size() - 1]));
        fare.addFareDetails(fareType, details);
        return count > 0;
    }

    protected float calculateCost(FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        return this.getBestFareAndId((FareType)fareType, rides, fareRules).fare;
    }

    protected FareAndId getBestFareAndId(FareType fareType, List<Leg> legs, Collection<FareRuleSet> fareRules) {
        HashSet<String> zones = new HashSet<String>();
        HashSet<FeedScopedId> routes = new HashSet<FeedScopedId>();
        HashSet<FeedScopedId> trips = new HashSet<FeedScopedId>();
        int transfersUsed = -1;
        Leg firstRide = legs.get(0);
        ZonedDateTime startTime = firstRide.getStartTime();
        String startZone = firstRide.getFrom().stop.getFirstZoneAsString();
        String endZone = null;
        String feedId = firstRide.getTrip().getId().getFeedId();
        ZonedDateTime lastRideStartTime = null;
        ZonedDateTime lastRideEndTime = null;
        for (Leg leg : legs) {
            if (!leg.getTrip().getId().getFeedId().equals(feedId)) {
                LOG.debug("skipped multi-feed ride sequence {}", legs);
                return new FareAndId(Float.POSITIVE_INFINITY, null);
            }
            lastRideStartTime = leg.getStartTime();
            lastRideEndTime = leg.getEndTime();
            endZone = leg.getTo().stop.getFirstZoneAsString();
            routes.add(leg.getRoute().getId());
            trips.add(leg.getTrip().getId());
            for (FareZone z : leg.getFareZones()) {
                zones.add(z.getId().getId());
            }
            ++transfersUsed;
        }
        AbstractTransitEntity bestAttribute = null;
        float bestFare = Float.POSITIVE_INFINITY;
        Duration tripTime = Duration.between(startTime, lastRideStartTime);
        Duration journeyTime = Duration.between(startTime, lastRideEndTime);
        for (FareRuleSet ruleSet : fareRules) {
            float newFare;
            FareAttribute attribute = ruleSet.getFareAttribute();
            if (!attribute.getId().getFeedId().equals(feedId) || !ruleSet.matches(startZone, endZone, zones, routes, trips) || attribute.isTransfersSet() && attribute.getTransfers() < transfersUsed || attribute.isTransferDurationSet() && tripTime.getSeconds() > (long)attribute.getTransferDuration().intValue() || attribute.isJourneyDurationSet() && journeyTime.getSeconds() > (long)attribute.getJourneyDuration().intValue() || !((newFare = this.getFarePrice(attribute, fareType)) < bestFare)) continue;
            bestAttribute = attribute;
            bestFare = newFare;
        }
        LOG.debug("{} best for {}", bestAttribute, legs);
        if (bestFare == Float.POSITIVE_INFINITY) {
            LOG.debug("No fare for a ride sequence: {}", legs);
        }
        return new FareAndId(bestFare, bestAttribute == null ? null : bestAttribute.getId());
    }

    protected float getFarePrice(FareAttribute fare, FareType type) {
        switch (type) {
            case senior: {
                if (!(fare.getSeniorPrice() >= 0.0f)) break;
                return fare.getSeniorPrice();
            }
            case youth: {
                if (!(fare.getYouthPrice() >= 0.0f)) break;
                return fare.getYouthPrice();
            }
        }
        return fare.getPrice();
    }

    protected boolean shouldCombineInterlinedLegs(ScheduledTransitLeg previousLeg, ScheduledTransitLeg currentLeg) {
        return false;
    }

    private List<Leg> combineInterlinedLegs(List<Leg> fareLegs) {
        ArrayList<Leg> result = new ArrayList<Leg>();
        for (Leg leg : fareLegs) {
            if (leg.isInterlinedWithPreviousLeg().booleanValue() && leg instanceof ScheduledTransitLeg) {
                ScheduledTransitLeg previousLeg;
                ScheduledTransitLeg currentLeg = (ScheduledTransitLeg)leg;
                Leg leg2 = result.get(result.size() - 1);
                if (leg2 instanceof ScheduledTransitLeg && this.shouldCombineInterlinedLegs(previousLeg = (ScheduledTransitLeg)leg2, currentLeg)) {
                    CombinedInterlinedTransitLeg combinedLeg = new CombinedInterlinedTransitLeg(previousLeg, currentLeg);
                    result.set(result.size() - 1, combinedLeg);
                    continue;
                }
            }
            result.add(leg);
        }
        return result;
    }

    private FareSearch performSearch(FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        FareSearch r = new FareSearch(rides.size());
        for (int i = 0; i < rides.size(); ++i) {
            for (int j = 0; j < rides.size() - i; ++j) {
                FareAndId best = this.getBestFareAndId(fareType, rides.subList(j, j + i + 1), fareRules);
                float cost = best.fare;
                if (cost < 0.0f) {
                    LOG.error("negative cost for a ride sequence");
                    cost = Float.POSITIVE_INFINITY;
                }
                if (cost < Float.POSITIVE_INFINITY) {
                    r.endOfComponent[j] = j + i;
                    r.next[j][j + i] = j + i;
                }
                r.resultTable[j][j + i] = cost;
                r.fareIds[j][j + i] = best.fareId;
                for (int k = 0; k < i; ++k) {
                    float via = r.resultTable[j][j + k] + r.resultTable[j + k + 1][j + i];
                    if (!(r.resultTable[j][j + i] > via)) continue;
                    r.resultTable[j][j + i] = via;
                    r.endOfComponent[j] = j + i;
                    r.next[j][j + i] = r.next[j][j + k];
                }
            }
        }
        return r;
    }
}

