/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.tokenizer.UnknownFunctionOrVariableException;
import org.opentripplanner.ext.dataoverlay.configuration.TimeUnit;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.ext.dataoverlay.routing.Parameter;
import org.opentripplanner.street.model.edge.StreetEdgeCostExtension;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataOverlayStreetEdgeCostExtension
implements StreetEdgeCostExtension,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DataOverlayStreetEdgeCostExtension.class);
    private final Instant dataStartTime;
    private final Map<String, float[]> variableValues;
    private final TimeUnit timeUnit;

    DataOverlayStreetEdgeCostExtension(Instant dataStartTime, Map<String, float[]> variableValues, TimeUnit timeUnit) {
        this.dataStartTime = dataStartTime;
        this.variableValues = variableValues;
        this.timeUnit = timeUnit;
    }

    @Override
    public double calculateExtraCost(State state, int edgeLength, TraverseMode traverseMode) {
        if (traverseMode.isWalking() || traverseMode.isCyclingIsh()) {
            return this.calculateDataOverlayPenalties(state) * (double)edgeLength / 1000.0;
        }
        return 0.0;
    }

    private double calculateDataOverlayPenalties(State s) {
        if (this.variableValues == null) {
            return 0.0;
        }
        double totalPenalty = 0.0;
        Instant requestInstant = s.getRequest().startTime();
        DataOverlayContext context = s.dataOverlayContext();
        for (Parameter parameter : context.getParameters()) {
            int dataQualityRequestedTime;
            double threshold = parameter.getThreshold();
            double penalty = parameter.getPenalty();
            String indexVariableName = parameter.getVariable();
            Instant dataStartTime = Instant.EPOCH;
            float[] genDataValuesForTime = new float[]{};
            if (this.variableValues.containsKey(indexVariableName)) {
                dataStartTime = this.dataStartTime;
                genDataValuesForTime = this.variableValues.get(indexVariableName);
            }
            if ((dataQualityRequestedTime = this.timeUnit.between(dataStartTime, requestInstant)) < 0) continue;
            if (dataQualityRequestedTime < genDataValuesForTime.length) {
                float value = genDataValuesForTime[dataQualityRequestedTime];
                String penaltyFormulaString = parameter.getFormula();
                double penaltyForParameters = this.calculatePenaltyFromParameters(penaltyFormulaString, value, threshold, penalty);
                if (!(penaltyForParameters >= 0.0)) continue;
                totalPenalty += penaltyForParameters;
                continue;
            }
            LOG.warn("No available data overlay for the given time");
        }
        return totalPenalty;
    }

    private double calculatePenaltyFromParameters(String formula, float value, double threshold, double penalty) {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("THRESHOLD", threshold);
        variables.put("PENALTY", penalty);
        variables.put("VALUE", Double.valueOf(value));
        try {
            Expression expression = new ExpressionBuilder(formula).variables(variables.keySet().toArray(new String[0])).build().setVariables(variables);
            return expression.evaluate();
        }
        catch (UnknownFunctionOrVariableException ex) {
            throw new IllegalArgumentException(String.format("Formula %s did not receive all the required parameters", formula));
        }
    }
}

