/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.accessibilityscore;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.ScheduledTransitLeg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.algorithm.filterchain.ItineraryListFilter;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.WheelchairTraversalInformation;
import org.opentripplanner.transit.model.basic.Accessibility;

public record AccessibilityScoreFilter(double wheelchairMaxSlope) implements ItineraryListFilter
{
    public static Float compute(List<Leg> legs) {
        return legs.stream().map(Leg::accessibilityScore).filter(Objects::nonNull).min(Comparator.comparingDouble(Float::doubleValue)).orElse(null);
    }

    public static float compute(ScheduledTransitLeg leg) {
        Accessibility fromStop = leg.getFrom().stop.getWheelchairAccessibility();
        Accessibility toStop = leg.getFrom().stop.getWheelchairAccessibility();
        Accessibility trip = leg.getTripWheelchairAccessibility();
        List<Accessibility> values = List.of(trip, fromStop, toStop);
        float sum = (float)values.stream().mapToDouble(AccessibilityScoreFilter::accessibilityScore).sum();
        return sum / (float)values.size();
    }

    @Override
    public List<Itinerary> filter(List<Itinerary> itineraries) {
        return itineraries.stream().map(this::addAccessibilityScore).toList();
    }

    private static double accessibilityScore(Accessibility wheelchair) {
        return switch (wheelchair) {
            default -> throw new IncompatibleClassChangeError();
            case Accessibility.NO_INFORMATION -> 0.5;
            case Accessibility.POSSIBLE -> 1.0;
            case Accessibility.NOT_POSSIBLE -> 0.0;
        };
    }

    private float compute(StreetLeg leg) {
        List<List> edges = leg.getWalkSteps().stream().map(WalkStep::getEdges).toList();
        List<StreetEdge> streetEdges = edges.stream().filter(StreetEdge.class::isInstance).map(StreetEdge.class::cast).toList();
        double maxSlope = streetEdges.stream().filter(StreetEdge::hasElevationExtension).mapToDouble(StreetEdge::getMaxSlope).max().orElse(0.0);
        float score = 0.0f;
        double maxSlopeExceeded = streetEdges.stream().filter((? super T s) -> s.getMaxSlope() > maxSlope).mapToDouble(s -> s.getMaxSlope() - maxSlope).map(d -> d * 100.0).max().orElse(0.0);
        double slopeMalus = maxSlopeExceeded * maxSlopeExceeded / 10.0;
        score = (float)((double)score + (0.5 - slopeMalus));
        boolean allEdgesAreAccessible = edges.stream().filter(WheelchairTraversalInformation.class::isInstance).map(WheelchairTraversalInformation.class::cast).allMatch(WheelchairTraversalInformation::isWheelchairAccessible);
        if (allEdgesAreAccessible) {
            score += 0.5f;
        }
        return Math.max(score, 0.0f);
    }

    private Itinerary addAccessibilityScore(Itinerary i) {
        List<Leg> scoredLegs = i.getLegs().stream().map(leg -> {
            if (leg instanceof ScheduledTransitLeg) {
                ScheduledTransitLeg transitLeg = (ScheduledTransitLeg)leg;
                return transitLeg.withAccessibilityScore(Float.valueOf(AccessibilityScoreFilter.compute(transitLeg)));
            }
            if (leg instanceof StreetLeg) {
                StreetLeg streetLeg = (StreetLeg)leg;
                return streetLeg.withAccessibilityScore(this.compute(streetLeg));
            }
            return leg;
        }).toList();
        i.setLegs(scoredLegs);
        i.setAccessibilityScore(AccessibilityScoreFilter.compute(scoredLegs));
        return i;
    }
}

