/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.https;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.https.HttpsDataSourceMetadata;
import org.opentripplanner.framework.io.HttpUtils;

record HttpsFileDataSource(URI uri, FileType type, HttpsDataSourceMetadata httpsDataSourceMetadata) implements DataSource
{
    private static final Duration HTTP_GET_REQUEST_TIMEOUT = Duration.ofSeconds(20L);

    @Override
    public long size() {
        return this.httpsDataSourceMetadata.contentLength();
    }

    @Override
    public long lastModified() {
        return this.httpsDataSourceMetadata.lastModified();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public InputStream asInputStream() {
        InputStream in;
        try {
            in = HttpUtils.getData(this.uri, HTTP_GET_REQUEST_TIMEOUT, Map.of());
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getLocalizedMessage(), e);
        }
        if (this.httpsDataSourceMetadata().isGzipContentType() || this.uri.getPath().endsWith(".gz")) {
            try {
                return new GZIPInputStream(in);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getLocalizedMessage(), e);
            }
        }
        return in;
    }

    @Override
    public OutputStream asOutputStream() {
        throw new UnsupportedOperationException("Write operations are not available for HTTPS data sources");
    }

    @Override
    public String name() {
        return this.uri.getPath().substring(this.uri.getPath().lastIndexOf(47) + 1);
    }

    @Override
    public String path() {
        return this.uri.toString();
    }

    @Override
    public String directory() {
        int endIndex = this.path().lastIndexOf(this.name()) - 1;
        return endIndex <= 0 ? "" : this.path().substring(0, endIndex);
    }
}

