/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.file.FileDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFileDataSource
extends FileDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryFileDataSource.class);
    private final String originalName;

    public TemporaryFileDataSource(String originalName, File file, FileType type) {
        super(file, type);
        this.originalName = originalName;
    }

    @Override
    public String name() {
        return this.originalName;
    }

    public void deleteFile() {
        try {
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            LOG.warn("Could not delete temporary file {} for temporary file datasource {}", new Object[]{this.file.getName(), this.name(), e});
        }
    }
}

