/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;

public class ByteArrayDataSource
implements DataSource {
    private final String path;
    private final String name;
    private final FileType type;
    private final long size;
    private final long lastModified;
    private final boolean writable;
    private ByteArrayOutputStream out = null;
    private byte[] buffer;

    public ByteArrayDataSource(String path, String name, FileType type, long size, long lastModified, boolean writable) {
        this.path = path;
        this.name = name;
        this.type = type;
        this.size = size;
        this.lastModified = lastModified;
        this.writable = writable;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public URI uri() {
        return URI.create(this.path());
    }

    @Override
    public FileType type() {
        return this.type;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public InputStream asInputStream() {
        return new ByteArrayInputStream(this.asBytes());
    }

    @Override
    public byte[] asBytes() {
        return this.buffer == null ? this.out.toByteArray() : this.buffer;
    }

    @Override
    public OutputStream asOutputStream() {
        if (!this.writable) {
            throw new UnsupportedOperationException("This datasource type " + this.type() + " do not support WRITING. Can not write to: " + this.path());
        }
        if (this.out == null) {
            this.out = new ByteArrayOutputStream(1024);
            this.buffer = null;
        }
        return this.out;
    }

    public String toString() {
        return this.type + " " + this.path();
    }

    public ByteArrayDataSource withBytes(byte[] buffer) {
        this.buffer = buffer;
        this.out = null;
        return this;
    }
}

