/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.astar.strategy;

import java.time.Duration;
import org.opentripplanner.astar.spi.AStarEdge;
import org.opentripplanner.astar.spi.AStarState;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;

public class DurationSkipEdgeStrategy<State extends AStarState<State, Edge, ?>, Edge extends AStarEdge<State, Edge, ?>>
implements SkipEdgeStrategy<State, Edge> {
    private final double durationInSeconds;

    public DurationSkipEdgeStrategy(Duration duration) {
        this.durationInSeconds = duration.toSeconds();
    }

    @Override
    public boolean shouldSkipEdge(State current, Edge edge) {
        return (double)current.getElapsedTimeSeconds() > this.durationInSeconds;
    }
}

