/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.opentripplanner.api.model.serverinfo.ApiServerInfo;
import org.opentripplanner.model.projectinfo.OtpProjectInfo;

@Path(value="/")
public class ServerInfo {
    private static final ApiServerInfo SERVER_INFO = ServerInfo.createServerInfo();

    public static ApiServerInfo createServerInfo() {
        String cpuName = "unknown";
        int nCores = 0;
        try {
            String line;
            FileInputStream fis = new FileInputStream("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("model name")) continue;
                cpuName = line.split(": ")[1];
                ++nCores;
            }
            ((InputStream)fis).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ApiServerInfo(cpuName, nCores, OtpProjectInfo.projectInfo());
    }

    @GET
    @Produces(value={"application/json"})
    public ApiServerInfo getServerInfo() {
        return SERVER_INFO;
    }
}

