/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.glassfish.grizzly.http.server.Request;
import org.opentripplanner.api.common.Message;
import org.opentripplanner.api.common.RoutingResource;
import org.opentripplanner.api.mapping.PlannerErrorMapper;
import org.opentripplanner.api.mapping.TripPlanMapper;
import org.opentripplanner.api.mapping.TripSearchMetadataMapper;
import org.opentripplanner.api.model.error.PlannerError;
import org.opentripplanner.api.resource.ElevationMetadata;
import org.opentripplanner.api.resource.TripPlannerResponse;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="routers/{ignoreRouterId}/plan")
public class PlannerResource
extends RoutingResource {
    private static final Logger LOG = LoggerFactory.getLogger(PlannerResource.class);
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;

    @GET
    @Produces(value={"application/json"})
    public TripPlannerResponse plan(@Context UriInfo uriInfo, @Context Request grizzlyRequest) {
        TripPlannerResponse response = new TripPlannerResponse(uriInfo);
        RouteRequest request = null;
        RoutingResponse res = null;
        try {
            request = super.buildRequest((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
            res = this.serverContext.routingService().route(request);
            TripPlanMapper tripPlanMapper = new TripPlanMapper(request.locale(), this.showIntermediateStops);
            response.setPlan(tripPlanMapper.mapTripPlan(res.getTripPlan()));
            if (res.getPreviousPageCursor() != null) {
                response.setPreviousPageCursor(res.getPreviousPageCursor().encode());
            }
            if (res.getNextPageCursor() != null) {
                response.setNextPageCursor(res.getNextPageCursor().encode());
            }
            response.setMetadata(TripSearchMetadataMapper.mapTripSearchMetadata(res.getMetadata()));
            if (!res.getRoutingErrors().isEmpty()) {
                response.setError(PlannerErrorMapper.mapMessage(res.getRoutingErrors().get(0)));
            }
            response.elevationMetadata = new ElevationMetadata();
            response.elevationMetadata.ellipsoidToGeoidDifference = this.serverContext.graph().ellipsoidToGeoidDifference;
            response.elevationMetadata.geoidElevation = request.preferences().system().geoidElevation();
            response.debugOutput = res.getDebugTimingAggregator().finishedRendering();
        }
        catch (Exception e) {
            LOG.error("System error", (Throwable)e);
            PlannerError error = new PlannerError(Message.SYSTEM_ERROR);
            response.setError(error);
        }
        this.logRequest(grizzlyRequest, request, this.serverContext, res);
        return response;
    }

    private void logRequest(Request grizzlyRequest, RouteRequest request, OtpServerRequestContext serverContext, RoutingResponse res) {
        if (request != null && serverContext != null && serverContext.requestLogger() != null) {
            StringBuilder sb = new StringBuilder();
            String clientIpAddress = grizzlyRequest.getRemoteAddr();
            sb.append(clientIpAddress);
            sb.append(' ');
            sb.append(request.arriveBy() ? "ARRIVE" : "DEPART");
            sb.append(' ');
            sb.append(LocalDateTime.ofInstant(request.dateTime(), ZoneId.systemDefault()));
            sb.append(' ');
            sb.append(request.journey().transit().filters());
            sb.append(' ');
            sb.append(request.from().lat);
            sb.append(' ');
            sb.append(request.from().lng);
            sb.append(' ');
            sb.append(request.to().lat);
            sb.append(' ');
            sb.append(request.to().lng);
            sb.append(' ');
            if (res != null) {
                for (Itinerary it : res.getTripPlan().itineraries) {
                    sb.append(it.getDuration());
                    sb.append(' ');
                }
            }
            serverContext.requestLogger().info(sb.toString());
        }
    }
}

