/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import org.glassfish.grizzly.http.server.Request;
import org.opentripplanner.api.model.TileJson;
import org.opentripplanner.inspector.vector.AreaStopsLayerBuilder;
import org.opentripplanner.inspector.vector.LayerBuilder;
import org.opentripplanner.inspector.vector.LayerParameters;
import org.opentripplanner.inspector.vector.VectorTileResponseFactory;
import org.opentripplanner.inspector.vector.geofencing.GeofencingZonesLayerBuilder;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;
import org.opentripplanner.standalone.api.OtpServerRequestContext;

@Path(value="/routers/{ignoreRouterId}/inspector/vectortile")
public class GraphInspectorVectorTileResource {
    private static final List<LayerParameters<LayerType>> DEBUG_LAYERS = List.of(new LayerParams("areaStops", LayerType.AreaStop), new LayerParams("geofencingZones", LayerType.GeofencingZones));
    private final OtpServerRequestContext serverContext;
    private final String ignoreRouterId;

    public GraphInspectorVectorTileResource(@Context OtpServerRequestContext serverContext, @Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.serverContext = serverContext;
        this.ignoreRouterId = ignoreRouterId;
    }

    @GET
    @Path(value="/{layers}/{z}/{x}/{y}.pbf")
    @Produces(value={"application/x-protobuf"})
    public Response tileGet(@Context Request grizzlyRequest, @PathParam(value="x") int x, @PathParam(value="y") int y, @PathParam(value="z") int z, @PathParam(value="layers") String requestedLayers) {
        return VectorTileResponseFactory.create(x, y, z, grizzlyRequest.getLocale(), Arrays.asList(requestedLayers.split(",")), DEBUG_LAYERS, GraphInspectorVectorTileResource::createLayerBuilder, this.serverContext);
    }

    @GET
    @Path(value="/{layers}/tilejson.json")
    @Produces(value={"application/json"})
    public TileJson getTileJson(@Context UriInfo uri, @Context HttpHeaders headers, @PathParam(value="layers") String requestedLayers) {
        WorldEnvelope envelope = this.serverContext.worldEnvelopeService().envelope().orElseThrow();
        List<FeedInfo> feedInfos = this.serverContext.transitService().getFeedIds().stream().map(this.serverContext.transitService()::getFeedInfo).filter(Predicate.not(Objects::isNull)).toList();
        return new TileJson(uri, headers, requestedLayers, this.ignoreRouterId, "inspector/vectortile", envelope, feedInfos);
    }

    private static LayerBuilder<?> createLayerBuilder(LayerParameters<LayerType> layerParameters, Locale locale, OtpServerRequestContext context) {
        return switch (layerParameters.type()) {
            default -> throw new IncompatibleClassChangeError();
            case LayerType.AreaStop -> new AreaStopsLayerBuilder(context.transitService(), layerParameters, locale);
            case LayerType.GeofencingZones -> new GeofencingZonesLayerBuilder(context.graph(), layerParameters);
        };
    }

    private static enum LayerType {
        AreaStop,
        GeofencingZones;

    }

    private static final class LayerParams
    extends Record
    implements LayerParameters<LayerType> {
        private final String name;
        private final LayerType type;

        private LayerParams(String name, LayerType type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String mapper() {
            return "DebugClient";
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LayerParams.class, "name;type", "name", "type"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LayerParams.class, "name;type", "name", "type"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LayerParams.class, "name;type", "name", "type"}, this, o);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public LayerType type() {
            return this.type;
        }
    }
}

