/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.model;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.io.HttpUtils;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;

public class TileJson
implements Serializable {
    public final String tilejson = "2.2.0";
    public final String scheme = "xyz";
    public final int minzoom = 9;
    public final int maxzoom = 20;
    public final String name = "OpenTripPlanner";
    public final String attribution;
    public final String[] tiles;
    public final double[] bounds;
    public final double[] center;

    public TileJson(UriInfo uri, HttpHeaders headers, String layers, String ignoreRouterId, String path, WorldEnvelope envelope, Collection<FeedInfo> feedInfos) {
        this.attribution = feedInfos.stream().map(feedInfo -> "<a href='" + feedInfo.getPublisherUrl() + "'>" + feedInfo.getPublisherName() + "</a>").collect(Collectors.joining(", "));
        this.tiles = new String[]{"%s/otp/routers/%s/%s/%s/{z}/{x}/{y}.pbf".formatted(HttpUtils.getBaseAddress(uri, headers), ignoreRouterId, path, layers)};
        this.bounds = new double[]{envelope.lowerLeft().longitude(), envelope.lowerLeft().latitude(), envelope.upperRight().longitude(), envelope.upperRight().latitude()};
        WgsCoordinate c = envelope.center();
        this.center = new double[]{c.longitude(), c.latitude(), 9.0};
    }
}

