/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opentripplanner.api.model.ApiTravelOption;
import org.opentripplanner.api.parameter.ApiRequestMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.service.TransitService;

public final class ApiTravelOptionsMaker {
    private static final List<ApiTravelOption> staticTravelOptions = new ArrayList<ApiTravelOption>(3);

    public static List<ApiTravelOption> makeOptions(Graph graph, VehicleRentalService vehicleRentalService, TransitService transitService) {
        VehicleParkingService service = graph.getVehicleParkingService();
        return ApiTravelOptionsMaker.makeOptions(transitService.getTransitModes(), vehicleRentalService.hasRentalBikes(), service.hasBikeParking(), service.hasCarParking());
    }

    public static List<ApiTravelOption> makeOptions(Set<TransitMode> transitModes, boolean hasBikeSharing, boolean hasBikeRide, boolean hasParkRide) {
        ArrayList<ApiTravelOption> travelOptions = new ArrayList<ApiTravelOption>(16);
        if (!transitModes.isEmpty()) {
            travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.WALK.toString()), ApiRequestMode.TRANSIT.toString()));
            for (TransitMode transitMode : transitModes) {
                travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", transitMode.toString(), ApiRequestMode.WALK.toString()), transitMode.toString()));
            }
        }
        travelOptions.addAll(staticTravelOptions);
        if (hasBikeSharing) {
            travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", ApiRequestMode.WALK.toString(), "BICYCLE_RENT"), "BICYCLERENT"));
        }
        if (!transitModes.isEmpty()) {
            travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.BICYCLE.toString()), String.join((CharSequence)"_", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.BICYCLE.toString())));
            if (hasBikeSharing) {
                travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", ApiRequestMode.TRANSIT.toString(), ApiRequestMode.WALK.toString(), "BICYCLE_RENT"), "TRANSIT_BICYCLERENT"));
            }
            if (hasParkRide) {
                travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", "CAR_PARK", ApiRequestMode.WALK.toString(), ApiRequestMode.TRANSIT.toString()), "PARKRIDE"));
            }
            if (hasBikeRide) {
                travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", "BICYCLE_PARK", ApiRequestMode.WALK.toString(), ApiRequestMode.TRANSIT.toString()), "BIKERIDE"));
            }
            travelOptions.add(new ApiTravelOption(String.join((CharSequence)",", ApiRequestMode.CAR.toString(), ApiRequestMode.WALK.toString(), ApiRequestMode.TRANSIT.toString()), "KISSRIDE"));
        }
        return travelOptions;
    }

    static {
        staticTravelOptions.add(new ApiTravelOption(ApiRequestMode.WALK.toString()));
        staticTravelOptions.add(new ApiTravelOption(ApiRequestMode.BICYCLE.toString()));
        staticTravelOptions.add(new ApiTravelOption(ApiRequestMode.CAR.toString()));
    }
}

