/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.model;

import java.util.Date;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.ModeMapper;
import org.opentripplanner.api.model.ApiTravelOption;
import org.opentripplanner.api.model.ApiTravelOptionsMaker;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.service.vehiclerental.VehicleRentalService;
import org.opentripplanner.service.worldenvelope.model.WorldEnvelope;
import org.opentripplanner.transit.service.TransitService;

public class ApiRouterInfo {
    private final WorldEnvelope envelope;
    public final boolean hasBikePark;
    public final boolean hasCarPark;
    public final boolean hasVehicleParking;
    public String routerId;
    public Geometry polygon;
    public Date buildTime;
    public long transitServiceStarts;
    public long transitServiceEnds;
    public List<String> transitModes;
    public boolean hasParkRide;
    public boolean hasBikeSharing;
    public List<ApiTravelOption> travelOptions;

    public ApiRouterInfo(String routerId, Graph graph, TransitService transitService, VehicleRentalService vehicleRentalService, WorldEnvelope envelope) {
        VehicleParkingService vehicleParkingService = graph.getVehicleParkingService();
        this.routerId = routerId;
        this.polygon = graph.getConvexHull();
        this.buildTime = Date.from(graph.buildTime);
        this.transitServiceStarts = transitService.getTransitServiceStarts().toEpochSecond();
        this.transitServiceEnds = transitService.getTransitServiceEnds().toEpochSecond();
        this.transitModes = ModeMapper.mapToApi(transitService.getTransitModes());
        this.envelope = envelope;
        this.hasBikeSharing = this.mapHasBikeSharing(vehicleRentalService);
        this.hasBikePark = this.mapHasBikePark(vehicleParkingService);
        this.hasParkRide = this.hasCarPark = this.mapHasCarPark(vehicleParkingService);
        this.hasVehicleParking = this.mapHasVehicleParking(vehicleParkingService);
        this.travelOptions = ApiTravelOptionsMaker.makeOptions(graph, vehicleRentalService, transitService);
    }

    public boolean mapHasBikeSharing(VehicleRentalService service) {
        if (service == null) {
            return false;
        }
        return service.getVehicleRentalPlaces().size() > 1;
    }

    public boolean mapHasBikePark(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getBikeParks().findAny().isPresent();
    }

    public boolean mapHasCarPark(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getCarParks().findAny().isPresent();
    }

    public boolean mapHasVehicleParking(VehicleParkingService service) {
        if (service == null) {
            return false;
        }
        return service.getVehicleParkings().findAny().isPresent();
    }

    public double getLowerLeftLatitude() {
        return this.envelope.lowerLeft().latitude();
    }

    public double getLowerLeftLongitude() {
        return this.envelope.lowerLeft().longitude();
    }

    public double getUpperRightLatitude() {
        return this.envelope.upperRight().latitude();
    }

    public double getUpperRightLongitude() {
        return this.envelope.upperRight().longitude();
    }

    public double getCenterLatitude() {
        return this.envelope.center().latitude();
    }

    public double getCenterLongitude() {
        return this.envelope.center().longitude();
    }
}

