/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import org.opentripplanner.transit.model.basic.TransitMode;

public class RouteTypeMapper {
    private static final int DEFAULT_ROUTE_TYPE = -1;

    public static int mapToApi(TransitMode domain) {
        if (domain == null) {
            return -1;
        }
        return switch (domain) {
            default -> throw new IncompatibleClassChangeError();
            case TransitMode.RAIL -> 2;
            case TransitMode.COACH, TransitMode.BUS -> 3;
            case TransitMode.SUBWAY -> 1;
            case TransitMode.TRAM -> 0;
            case TransitMode.FERRY -> 4;
            case TransitMode.AIRPLANE -> 1100;
            case TransitMode.CABLE_CAR -> 5;
            case TransitMode.GONDOLA -> 6;
            case TransitMode.FUNICULAR -> 7;
            case TransitMode.TROLLEYBUS -> 11;
            case TransitMode.MONORAIL -> 12;
            case TransitMode.TAXI -> 1500;
            case TransitMode.CARPOOL -> 1551;
        };
    }
}

